/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import java.text.DecimalFormat;
import projections.gui.MainWindow;
import projections.gui.graph.DataSource;

public class SummaryDataSource
extends DataSource {
    private int myRun = 0;
    private int startInterval;
    private int numIntervals;
    private double[][] dataValues;

    public SummaryDataSource(double[][] data, int startInt) {
        this.dataValues = data;
        this.numIntervals = data.length;
        this.startInterval = startInt;
    }

    public String getTitle() {
        return "Utilization Graph (Summary)";
    }

    public int getIndexCount() {
        return this.numIntervals;
    }

    public int getValueCount() {
        return this.dataValues[0].length;
    }

    public Color getColor(int valNo) {
        switch (valNo) {
            case 0: {
                return Color.red;
            }
            case 1: {
                return MainWindow.runObject[this.myRun].foreground;
            }
        }
        System.err.println("ERROR: Invalid value " + valNo + " requested for Summary colors");
        System.exit(-1);
        return null;
    }

    public void getValues(int index, double[] values) {
        for (int val = 0; val < this.getValueCount(); ++val) {
            values[val] = this.dataValues[index][val];
        }
    }

    public String[] getPopup(int xVal, int yVal) {
        String[] ret = new String[3];
        ret[0] = yVal == 0 ? "Average Processor Utilization (%)" : "Average Idle Percentage";
        ret[1] = "Interval: " + (xVal + this.startInterval);
        DecimalFormat numFormat = new DecimalFormat("###.00");
        ret[2] = "Percent: " + numFormat.format(this.dataValues[xVal][yVal]);
        return ret;
    }
}

