/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import projections.gui.U;
import projections.gui.graph.YAxis;

public class YAxisFixed
extends YAxis {
    private String title;
    private String units;
    private double max;

    public YAxisFixed(String title_, String units_, double max_) {
        this.title = title_;
        this.units = units_;
        this.max = max_;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUnits() {
        return this.units;
    }

    public double getMax() {
        return this.max;
    }

    public String getValueName(double value) {
        if (value > 1.0E9) {
            String m = "" + value / 1.0E9;
            m = U.truncateTrailingZeroPeriod(m);
            return "" + m + "G";
        }
        if (value > 1000000.0) {
            String m = "" + value / 1000000.0;
            m = U.truncateTrailingZeroPeriod(m);
            return "" + m + "M";
        }
        if (value > 1000.0) {
            String k = "" + value / 1000.0;
            k = U.truncateTrailingZeroPeriod(k);
            return "" + k + "K";
        }
        String v = "" + value;
        return U.truncateTrailingZeroPeriod(v);
    }
}

