/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import projections.analysis.ProjDefs;
import projections.gui.MainWindow;

public class LogEntryData
extends ProjDefs {
    private static int myRun = 0;
    private boolean isValid = true;
    public int type;
    public int mtype;
    public long time;
    public long endTime;
    public int entry;
    public int event;
    public int pe;
    public int numPEs;
    public int msglen;
    public int userEventID;
    public long sendTime;
    public long recvTime;
    public int[] id = new int[4];
    public long cpuStartTime;
    public long cpuEndTime;
    public int numPerfCounts;
    public long[] perfCounts;
    public int[] destPEs;
    public Integer userSupplied;
    public long memoryUsage;
    public String note;
    public int lineNo;
    public String funcName;

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean flag) {
        this.isValid = flag;
    }

    public String htmlFormattedDescription() {
        switch (this.type) {
            case 1: {
                return "<font size=+1 color=\"#660000\">CREATE</font> message to be sent to <em> " + MainWindow.runObject[myRun].getEntryFullNameByID(this.entry) + "</em>";
            }
            case 20: {
                if (this.numPEs == MainWindow.runObject[myRun].getNumProcessors()) {
                    return "<font size=+1 color=\"#666600\">GROUP BROADCAST</font> (" + this.numPEs + " processors)";
                }
                return "<font size=+1 color=\"#666600\">NODEGROUP BROADCAST</font> (" + this.numPEs + " processors)";
            }
            case 21: {
                return "<font size=+1 color=\"#666600\">MULTICAST</font> message sent to " + this.numPEs + " processors";
            }
            case 2: {
                return "<font size=+1 color=\"#000088\">BEGIN PROCESSING</font> of <em>" + MainWindow.runObject[myRun].getEntryFullNameByID(this.entry) + "</em> from processor " + this.pe + " event=" + this.event;
            }
            case 3: {
                return "<font size=+1 color=\"#000088\">END PROCESSING</font> of message sent to <em>" + MainWindow.runObject[myRun].getEntryFullNameByID(this.entry) + "</em> from processor " + this.pe;
            }
            case 4: {
                return "<font size=+1>ENQUEUEING</font> message received from processor " + this.pe + " destined for " + MainWindow.runObject[myRun].getEntryFullNameByID(this.entry);
            }
            case 14: {
                return "<font size=+1 color=\"#333333\">IDLE begin</font>";
            }
            case 15: {
                return "<font size=+1 color=\"#333333\">IDLE end</font>";
            }
            case 16: {
                return "<font size=+1 color=\"#008800\">BEGIN PACKING</font> a message to be sent";
            }
            case 17: {
                return "<font size=+1 color=\"#008800\">FINISHED PACKING</font> a message to be sent";
            }
            case 18: {
                return "<font size=+1 color=\"#880000\">BEGIN UNPACKING</font> a received message";
            }
            case 19: {
                return "<font size=+1 color=\"#880000\">FINISHED UNPACKING</font> a received message";
            }
            case 6: {
                return "<font size=+1 color=\"#888888\">BEGIN COMPUTATION</font>";
            }
            case 7: {
                return "<font size=+1 color=\"#888888\">END COMPUTATION</font>";
            }
            case 100: {
                String name = MainWindow.runObject[myRun].getUserEventName(this.userEventID);
                return "<font color=\"#F7D331\">Bracketed User Event (comes in pairs)</font>: " + name;
            }
            case 13: {
                String name2 = MainWindow.runObject[myRun].getUserEventName(this.userEventID);
                return "<font color=\"#F7D331\">User Event</font>: " + name2;
            }
            case 28: {
                if (this.note != null) {
                    return "<font size=+1 color=\"#880000\">USER SUPPLIED NOTE:</font> " + this.note;
                }
                return "<font size=+1 color=\"#880000\">USER SUPPLIED NOTE:</font> <i>blank</i>";
            }
        }
        System.out.println("Unknown event type");
        return "Unknown Event Type:" + this.type + " !!!";
    }

    public boolean isBeginType() {
        return this.type == 14 || this.type == 16 || this.type == 18 || this.type == 2 || this.type == 11 || this.type == 22 || this.type == 8;
    }

    public boolean isEndType() {
        return this.type == 15 || this.type == 17 || this.type == 19 || this.type == 3 || this.type == 12 || this.type == 23 || this.type == 9;
    }
}

