/*
 * Decompiled with CFR 0.152.
 */
package projections.misc;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ProgressMonitor;
import projections.analysis.GenericSummaryReader;
import projections.analysis.StsReader;
import projections.misc.FileUtils;
import projections.misc.MiscUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRunData {
    static int myRun = 0;
    private StsReader[] stsReaders;
    private int[] sortedStsMap;
    private double[][][] dataTable;
    public static final int NUM_TYPES = 4;
    public static final int TYPE_TIME = 0;
    public static final int TYPE_TIMES_CALLED = 1;
    public static final int TYPE_NUM_MSG_SENT = 2;
    public static final int TYPE_SIZE_MSG = 3;
    private static final String[] typeNames = new String[]{"Execution Time", "Num Msgs Received", "Num Msgs Sent", "Msg Size"};
    private double[] runWallTimes;
    private int numRuns;
    private int numEPs;
    private String[] epNames;
    private String[] runNames;
    private FileUtils[] fileNameHandlers;

    public MultiRunData(String[] listOfStsFilenames, Component rootComponent) throws IOException {
        try {
            int run;
            this.numRuns = listOfStsFilenames.length;
            if (this.numRuns == 0) {
                throw new IOException("MultiRunData cannot be initialized with zero runs!");
            }
            this.stsReaders = new StsReader[this.numRuns];
            this.fileNameHandlers = new FileUtils[this.numRuns];
            int[] pesPerRun = new int[this.numRuns];
            for (int run2 = 0; run2 < this.numRuns; ++run2) {
                this.stsReaders[run2] = new StsReader(listOfStsFilenames[run2]);
                this.fileNameHandlers[run2] = new FileUtils(listOfStsFilenames[run2]);
                pesPerRun[run2] = this.stsReaders[run2].getProcessorCount();
            }
            this.sortedStsMap = MiscUtil.sortAndMap(pesPerRun);
            MiscUtil.applyMap(this.stsReaders, this.sortedStsMap);
            ArrayList<ArrayList<SortedSet<Integer>>> validPESets = new ArrayList<ArrayList<SortedSet<Integer>>>(this.numRuns);
            boolean hasSummary = true;
            boolean hasLog = true;
            for (run = 0; run < this.numRuns; ++run) {
                validPESets.add(run, MultiRunData.detectFiles(this.stsReaders[run], this.fileNameHandlers[run]));
                hasSummary = hasSummary && !((SortedSet)((ArrayList)validPESets.get(run)).get(1)).isEmpty();
                hasLog = hasLog && !((SortedSet)((ArrayList)validPESets.get(run)).get(0)).isEmpty();
            }
            this.numEPs = this.stsReaders[0].getEntryCount();
            for (run = 1; run < this.numRuns; ++run) {
                if (this.numEPs == this.stsReaders[run].getEntryCount()) continue;
                System.err.println("Error! Incompatible data sets!");
                System.exit(-1);
            }
            this.epNames = new String[this.numEPs];
            for (int ep = 0; ep < this.numEPs; ++ep) {
                this.epNames[ep] = this.stsReaders[0].getEntryNameByID(ep);
            }
            this.runNames = new String[this.numRuns];
            for (run = 0; run < this.numRuns; ++run) {
                this.runNames[run] = "(" + pesPerRun[run] + ")" + "[" + this.stsReaders[run].getMachineName() + "]";
            }
            this.dataTable = new double[4][this.numRuns][this.numEPs];
            this.runWallTimes = new double[this.numRuns];
            if (hasSummary) {
                for (int run3 = 0; run3 < this.numRuns; ++run3) {
                    int numPE = pesPerRun[run3];
                    SortedSet validPEs = (SortedSet)((ArrayList)validPESets.get(run3)).get(1);
                    double scale = (double)numPE / ((double)validPEs.size() * 1.0);
                    ProgressMonitor progressBar = new ProgressMonitor(rootComponent, "Reading summary Data for run " + run3 + " of " + this.numRuns, "", 0, validPEs.size());
                    progressBar.setMillisToDecideToPopup(100);
                    progressBar.setMillisToPopup(1000);
                    int count = 0;
                    for (Integer pe : validPEs) {
                        if (!progressBar.isCanceled()) {
                            progressBar.setNote("[PE: " + pe + " ] Reading Processor data.");
                            progressBar.setProgress(count);
                        } else {
                            System.err.println("Fatal error! Multirun  cannot function without  a complete read!");
                            System.exit(-1);
                        }
                        GenericSummaryReader reader = new GenericSummaryReader(this.fileNameHandlers[run3].getCanonicalFileName(pe, 1), this.stsReaders[run3].getVersion());
                        for (int ep = 0; ep < this.numEPs; ++ep) {
                            double[] dArray = this.dataTable[0][run3];
                            int n = ep;
                            dArray[n] = dArray[n] + (double)reader.epData[ep][0] * scale;
                            double[] dArray2 = this.dataTable[1][run3];
                            int n2 = ep;
                            dArray2[n2] = dArray2[n2] + (double)reader.epData[ep][1] * scale;
                        }
                        int n = run3;
                        this.runWallTimes[n] = this.runWallTimes[n] + (double)reader.numIntervals * reader.intervalSize * 1000000.0 * scale;
                        ++count;
                    }
                    progressBar.close();
                }
            } else if (!hasLog) {
                System.err.println("No data available! Catastrophic error!");
                System.exit(-1);
            }
        }
        catch (IOException e) {
            throw new IOException("MultiRun data read failed: 13" + e);
        }
    }

    public int getNumEPs() {
        return this.numEPs;
    }

    public int getNumRuns() {
        return this.numRuns;
    }

    public double[][] getData(int type) {
        return this.dataTable[type];
    }

    public double[][][] getData() {
        return this.dataTable;
    }

    public double[] getEPData(int type, int runID) {
        return this.dataTable[type][runID];
    }

    public double[] getRunData(int type, int ep) {
        double[] returnData = new double[this.numRuns];
        for (int run = 0; run < this.numRuns; ++run) {
            returnData[run] = this.dataTable[type][run][ep];
        }
        return returnData;
    }

    public double[] getRunWallTimes() {
        return this.runWallTimes;
    }

    public String[] getEPNames() {
        return this.epNames;
    }

    public String[] getRunNames() {
        return this.runNames;
    }

    public static String getTypeName(int dataType) {
        return typeNames[dataType];
    }

    private static ArrayList<SortedSet<Integer>> detectFiles(StsReader sts, FileUtils fileNameHandler) {
        int i;
        ArrayList<SortedSet<Integer>> validPEs = new ArrayList<SortedSet<Integer>>(5);
        for (i = 0; i < 5; ++i) {
            validPEs.add(new TreeSet());
        }
        for (i = 0; i < sts.getProcessorCount(); ++i) {
            if (new File(fileNameHandler.getCanonicalFileName(i, 1)).isFile()) {
                validPEs.get(1).add(i);
            }
            if (new File(fileNameHandler.getCanonicalFileName(i, 2)).isFile()) {
                validPEs.get(2).add(i);
            }
            if (!new File(fileNameHandler.getCanonicalFileName(i, 0)).isFile()) continue;
            validPEs.get(0).add(i);
        }
        return validPEs;
    }
}

