/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.io.IOException;
import java.util.Vector;
import projections.analysis.LogLoader;
import projections.analysis.LogReader;
import projections.analysis.StsReader;
import projections.analysis.SumAnalyzer;
import projections.analysis.UsageCalc;
import projections.analysis.ViewerEvent;
import projections.gui.OrderedIntList;
import projections.misc.EntryNotFoundException;
import projections.misc.LogLoadException;
import projections.misc.SummaryFormatException;

public class Analysis {
    private static StsReader sts;
    private static LogLoader logLoader;
    private static SumAnalyzer sumAnalyzer;
    private static int[][][] systemUsageData;
    private static int[][][][] systemMsgsData;
    private static int[][][][] userEntryData;

    public static Vector createTL(int n, long l, long l2) {
        try {
            if (logLoader != null) {
                return logLoader.createtimeline(n, l, l2);
            }
            return null;
        }
        catch (LogLoadException logLoadException) {
            System.out.println("LOG LOAD EXCEPTION");
            return null;
        }
    }

    public static int[][] getAnimationData(int n, int n2) {
        int n3 = (int)(sts.getTotalTime() / (long)n2);
        Analysis.LoadGraphData(n3, n2, false);
        int[][] nArray = new int[n][n3];
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n3) {
                nArray[n4][n5] = Analysis.getSystemUsageData(1)[n4][n5];
                ++n5;
            }
            ++n4;
        }
        return nArray;
    }

    public static String getFilename() {
        return sts.getFilename();
    }

    public static String[][] getLogFileText(int n) {
        if (logLoader == null) {
            return null;
        }
        Vector vector = null;
        try {
            vector = logLoader.view(n);
        }
        catch (LogLoadException logLoadException) {
            // empty catch block
        }
        if (vector == null) {
            return null;
        }
        int n2 = vector.size();
        if (n2 == 0) {
            return null;
        }
        String[][] stringArray = new String[n2][2];
        int n3 = 0;
        while (n3 < n2) {
            ViewerEvent viewerEvent = (ViewerEvent)vector.elementAt(n3);
            stringArray[n3][0] = "" + viewerEvent.Time;
            switch (viewerEvent.EventType) {
                case 1: {
                    stringArray[n3][1] = "CREATE message to be sent to " + viewerEvent.Dest;
                    break;
                }
                case 2: {
                    stringArray[n3][1] = "BEGIN PROCESSING of message sent to " + viewerEvent.Dest;
                    String[] stringArray2 = stringArray[n3];
                    stringArray2[1] = stringArray2[1] + " from processor " + viewerEvent.SrcPe;
                    break;
                }
                case 3: {
                    stringArray[n3][1] = "END PROCESSING of message sent to " + viewerEvent.Dest;
                    String[] stringArray3 = stringArray[n3];
                    stringArray3[1] = stringArray3[1] + " from processor " + viewerEvent.SrcPe;
                    break;
                }
                case 4: {
                    stringArray[n3][1] = "ENQUEUEING message received from processor " + viewerEvent.SrcPe + " destined for " + viewerEvent.Dest;
                    break;
                }
                case 14: {
                    stringArray[n3][1] = "IDLE begin";
                    break;
                }
                case 15: {
                    stringArray[n3][1] = "IDLE end";
                    break;
                }
                case 16: {
                    stringArray[n3][1] = "BEGIN PACKING a message to be sent";
                    break;
                }
                case 17: {
                    stringArray[n3][1] = "FINISHED PACKING a message to be sent";
                    break;
                }
                case 18: {
                    stringArray[n3][1] = "BEGIN UNPACKING a received message";
                    break;
                }
                case 19: {
                    stringArray[n3][1] = "FINISHED UNPACKING a received message";
                    break;
                }
                default: {
                    stringArray[n3][1] = "!!!! ADD EVENT TYPE " + viewerEvent.EventType + " !!!";
                }
            }
            ++n3;
        }
        return stringArray;
    }

    public static int getNumPhases() {
        if (sumAnalyzer != null) {
            return sumAnalyzer.GetPhaseCount();
        }
        return 0;
    }

    public static int getNumProcessors() {
        return sts.getProcessorCount();
    }

    public static int getNumUserEntries() {
        return sts.getEntryCount();
    }

    public static int[][] getSystemMsgsData(int n, int n2) {
        return systemMsgsData[n][n2];
    }

    public static int[][] getSystemUsageData(int n) {
        return systemUsageData[n];
    }

    public static long getTotalTime() {
        return sts.getTotalTime();
    }

    public static float[] GetUsageData(int n, long l, long l2, OrderedIntList orderedIntList) {
        long[][] lArray;
        Analysis.status("GetUsageData(pe " + n + "):");
        if (sts.hasLogFiles()) {
            UsageCalc usageCalc = new UsageCalc();
            return usageCalc.usage(sts, n, l, l2);
        }
        int n2 = sts.getEntryCount();
        if (sumAnalyzer.GetPhaseCount() > 1) {
            orderedIntList.reset();
            lArray = sumAnalyzer.GetPhaseChareTime(orderedIntList.nextElement());
            if (orderedIntList.hasMoreElements()) {
                while (orderedIntList.hasMoreElements() && n > -1) {
                    long[][] lArray2 = sumAnalyzer.GetPhaseChareTime(orderedIntList.nextElement());
                    int n3 = 0;
                    while (n3 < n2) {
                        long[] lArray3 = lArray[n];
                        int n4 = n3;
                        lArray3[n4] = lArray3[n4] + lArray2[n][n3];
                        ++n3;
                    }
                }
            }
        } else {
            lArray = sumAnalyzer.GetChareTime();
        }
        float[] fArray = new float[n2 + 4];
        double d = 100.0 / (double)sts.getTotalTime();
        int n5 = 0;
        while (n5 < n2) {
            fArray[n5] = (float)(d * (double)lArray[n][n5]);
            ++n5;
        }
        return fArray;
    }

    public static int[][] getUserEntryData(int n, int n2) {
        return userEntryData[n][n2];
    }

    public static String[][] getUserEntryNames() {
        return sts.getEntryNames();
    }

    public static boolean hasSystemMsgsData(int n, int n2) {
        if (systemMsgsData == null) {
            return false;
        }
        return null != systemMsgsData[n][n2];
    }

    public static boolean hasUserEntryData(int n, int n2) {
        if (userEntryData == null) {
            return false;
        }
        return null != userEntryData[n][n2];
    }

    public static void initAnalysis(String string) throws IOException {
        Analysis.status("initAnalysis(" + string + "):");
        sts = new StsReader(string);
        if (sts.hasSumFiles()) {
            try {
                sumAnalyzer = new SumAnalyzer(sts);
            }
            catch (SummaryFormatException summaryFormatException) {
                System.out.println("Caught SummaryFormatException");
            }
        } else {
            logLoader = new LogLoader(sts);
        }
    }

    public static void LoadGraphData(int n, long l, boolean bl) {
        Analysis.status("LoadGraphData(" + l + " us):");
        if (sts.hasLogFiles()) {
            LogReader logReader = new LogReader();
            logReader.read(sts, sts.getTotalTime(), l, bl);
            systemUsageData = logReader.getSystemUsageData();
            systemMsgsData = logReader.getSystemMsgs();
            userEntryData = logReader.getUserEntries();
            logReader = null;
        } else {
            systemUsageData = new int[3][][];
            try {
                Analysis.systemUsageData[1] = sumAnalyzer.GetSystemUsageData(n, l);
            }
            catch (SummaryFormatException summaryFormatException) {
                System.out.println("Caught SummaryFormatException");
            }
            catch (IOException iOException) {
                System.out.println("Caught IOExcpetion");
            }
        }
    }

    public static long searchTimeline(int n, int n2, int n3) throws EntryNotFoundException {
        try {
            return logLoader.searchtimeline(n2, n3, n);
        }
        catch (LogLoadException logLoadException) {
            System.out.println("LogLoadException");
            return -1L;
        }
    }

    private static void status(String string) {
    }
}

