/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import projections.gui.Analysis;
import projections.gui.BItem;
import projections.gui.GraphControlPanel;
import projections.gui.GraphDisplayPanel;
import projections.gui.GraphLegendPanel;
import projections.gui.GraphWindow;
import projections.gui.OrderedIntList;
import projections.gui.ZItem;

public class GraphData {
    static final int PROCESSOR = 0;
    static final int INTERVAL = 1;
    static final int TIME = 10;
    static final int MSGS = 11;
    static final int BOTH = 12;
    static final int LINE = 20;
    static final int BAR = 21;
    protected int numUserEntries = Analysis.getNumUserEntries();
    protected int graphtype = 21;
    protected int xmode = 1;
    protected int ymode = 11;
    protected int minx;
    protected int maxx;
    protected int offset = 10;
    protected int offset2 = 0;
    protected int offset3 = 0;
    protected float scale;
    protected double yscale = 1.0;
    protected double wscale = 1.0;
    protected double xscale;
    private float colorindex = 1.0f / (float)(this.numUserEntries + 7);
    private float colorvalue = 0.0f;
    private boolean colorflag = false;
    protected ZItem[] systemUsage;
    protected ZItem[][] systemMsgs;
    protected ZItem[][] userEntry;
    protected ZItem[] onGraph;
    protected BItem processor = new BItem();
    protected BItem interval;
    protected GraphControlPanel controlPanel;
    protected GraphLegendPanel legendPanel;
    protected GraphDisplayPanel displayPanel;
    protected GraphWindow graphWindow;

    public GraphData(int n, long l) {
        this.processor.num = Analysis.getNumProcessors();
        this.processor.list = new OrderedIntList();
        int n2 = 0;
        while (n2 < this.processor.num) {
            this.processor.list.insert(n2);
            ++n2;
        }
        this.processor.string = this.processor.list.listToString();
        String[] stringArray = new String[]{"Queue Size", "Processor Usage(%)", "Idle Time(%)"};
        this.systemUsage = new ZItem[3];
        int n3 = 0;
        while (n3 < 3) {
            this.systemUsage[n3] = new ZItem();
            this.systemUsage[n3].name = stringArray[n3];
            this.systemUsage[n3].exists = null != Analysis.getSystemUsageData(n3);
            float f = (float)(1.0 - (double)n3 * 0.3);
            this.systemUsage[n3].color = new Color(f, f, f);
            if (n3 == 1) {
                this.systemUsage[n3].state = true;
            }
            if (n3 == 0) {
                this.systemUsage[n3].type = "Msgs";
                this.systemUsage[n3].ymode = 11;
            } else {
                this.systemUsage[n3].type = "%";
                this.systemUsage[n3].ymode = 12;
            }
            ++n3;
        }
        this.onGraph = new ZItem[1];
        this.onGraph[0] = this.systemUsage[1];
        String[] stringArray2 = new String[]{"New Chare", "For Chare", "New Group", "Load Balancing", "Quiescence"};
        String[] stringArray3 = new String[]{"Creation", "Processing", "Time"};
        this.systemMsgs = new ZItem[5][3];
        int n4 = 0;
        while (n4 < 5) {
            int n5 = 0;
            while (n5 < 3) {
                this.systemMsgs[n4][n5] = new ZItem();
                this.systemMsgs[n4][n5].name = stringArray2[n4];
                this.systemMsgs[n4][n5].type = stringArray3[n5];
                this.systemMsgs[n4][n5].exists = Analysis.hasSystemMsgsData(n4, n5);
                if (n5 == 0) {
                    this.systemMsgs[n4][n5].color = this.nextColor();
                    this.systemMsgs[n4][n5].ymode = 11;
                } else if (n5 == 1) {
                    this.systemMsgs[n4][n5].color = this.systemMsgs[n4][0].color.darker();
                    this.systemMsgs[n4][n5].ymode = 11;
                } else if (n5 == 2) {
                    this.systemMsgs[n4][n5].color = this.systemMsgs[n4][0].color;
                    this.systemMsgs[n4][n5].ymode = 10;
                }
                ++n5;
            }
            ++n4;
        }
        String[][] stringArray4 = Analysis.getUserEntryNames();
        this.userEntry = new ZItem[this.numUserEntries][3];
        int n6 = 0;
        while (n6 < this.numUserEntries) {
            int n7 = 0;
            while (n7 < 3) {
                this.userEntry[n6][n7] = new ZItem();
                this.userEntry[n6][n7].name = stringArray4[n6][0];
                this.userEntry[n6][n7].type = stringArray3[n7];
                this.userEntry[n6][n7].parent = stringArray4[n6][1];
                this.userEntry[n6][n7].exists = Analysis.hasUserEntryData(n6, n7);
                if (n7 == 0) {
                    this.userEntry[n6][n7].color = this.nextColor();
                    this.userEntry[n6][n7].ymode = 11;
                } else if (n7 == 1) {
                    this.userEntry[n6][n7].color = this.userEntry[n6][0].color.darker();
                    this.userEntry[n6][n7].ymode = 11;
                } else if (n7 == 2) {
                    this.userEntry[n6][n7].color = this.userEntry[n6][0].color;
                    this.userEntry[n6][n7].ymode = 10;
                }
                ++n7;
            }
            ++n6;
        }
        this.initData(n, l);
    }

    public void initData(int n, long l) {
        int n2;
        this.scale = 1.0f;
        this.interval = new BItem();
        this.interval.num = n;
        this.interval.size = l;
        this.interval.list = new OrderedIntList();
        int n3 = 0;
        while (n3 < this.interval.num) {
            this.interval.list.insert(n3);
            ++n3;
        }
        this.interval.string = this.interval.list.listToString();
        int n4 = 0;
        while (n4 < 3) {
            if (null != Analysis.getSystemUsageData(n4)) {
                this.systemUsage[n4].data = Analysis.getSystemUsageData(n4);
                this.systemUsage[n4].curPData = new int[this.processor.num];
                this.systemUsage[n4].curIData = new int[this.interval.num];
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < 5) {
            n2 = 0;
            while (n2 < 3) {
                if (Analysis.hasSystemMsgsData(n5, n2)) {
                    this.systemMsgs[n5][n2].data = Analysis.getSystemMsgsData(n5, n2);
                    this.systemMsgs[n5][n2].curPData = new int[this.processor.num];
                    this.systemMsgs[n5][n2].curIData = new int[this.interval.num];
                }
                ++n2;
            }
            ++n5;
        }
        n2 = 0;
        while (n2 < this.numUserEntries) {
            int n6 = 0;
            while (n6 < 3) {
                if (Analysis.hasUserEntryData(n2, n6)) {
                    this.userEntry[n2][n6].data = Analysis.getUserEntryData(n2, n6);
                    this.userEntry[n2][n6].curPData = new int[this.processor.num];
                    this.userEntry[n2][n6].curIData = new int[this.interval.num];
                }
                ++n6;
            }
            ++n2;
        }
        this.setData();
    }

    private Color nextColor() {
        Color color = Color.getHSBColor((float)((double)this.colorvalue * 0.173 % 1.0), (float)(1.0 - 0.6 * ((double)this.colorvalue * 0.729 % 1.0)), 1.0f);
        this.colorvalue = (float)((double)this.colorvalue + 1.0);
        return color;
    }

    private int setCurIData(ZItem zItem) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.interval.num) {
            int n3;
            int n4 = 0;
            zItem.curIData[n2] = 0;
            this.processor.list.reset();
            while ((n3 = this.processor.list.nextElement()) >= 0) {
                int n5 = n2;
                zItem.curIData[n5] = zItem.curIData[n5] + zItem.data[n3][n2];
                ++n4;
            }
            if (zItem.ymode == 12) {
                int n6 = n2;
                zItem.curIData[n6] = zItem.curIData[n6] / n4;
            } else {
                n = Math.max(zItem.curIData[n2], n);
            }
            ++n2;
        }
        return n;
    }

    private int setCurPData(ZItem zItem) {
        int n = 0;
        int n2 = 0;
        while (n2 < this.processor.num) {
            int n3;
            int n4 = 0;
            zItem.curPData[n2] = 0;
            this.interval.list.reset();
            while ((n3 = this.interval.list.nextElement()) >= 0) {
                int n5 = n2;
                zItem.curPData[n5] = zItem.curPData[n5] + zItem.data[n2][n3];
                ++n4;
            }
            if (zItem.ymode == 12) {
                int n6 = n2;
                zItem.curPData[n6] = zItem.curPData[n6] / n4;
            } else {
                n = Math.max(zItem.curPData[n2], n);
            }
            ++n2;
        }
        return n;
    }

    public void setData() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.onGraph.length) {
            if (this.onGraph[n5].ymode == 12) {
                this.setCurPData(this.onGraph[n5]);
                this.setCurIData(this.onGraph[n5]);
            } else if (this.onGraph[n5].ymode == 10) {
                n2 = Math.max(this.setCurPData(this.onGraph[n5]), n2);
                n4 = Math.max(this.setCurIData(this.onGraph[n5]), n4);
            } else {
                n = Math.max(this.setCurPData(this.onGraph[n5]), n);
                n3 = Math.max(this.setCurIData(this.onGraph[n5]), n3);
            }
            ++n5;
        }
        this.processor.maxTime = n2;
        this.processor.maxMsgs = n;
        this.interval.maxTime = n4;
        this.interval.maxMsgs = n3;
    }
}

