/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.Analysis;
import projections.gui.LogFileViewerDialog;
import projections.gui.LogFileViewerTextArea;
import projections.gui.MainWindow;
import projections.gui.Util;

public class LogFileViewerWindow
extends Frame
implements ActionListener {
    private LogFileViewerDialog dialog;
    private int logfilenum = -1;
    private MainWindow mainWindow;
    private int oldlogfilenum = -1;
    private LogFileViewerTextArea textArea;
    private Label lTitle;
    private Button bOpen;
    private Button bClose;
    private Panel titlePanel;

    public LogFileViewerWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LogFileViewerWindow.this.Close();
            }
        });
        ((Component)this).setBackground(Color.lightGray);
        this.setTitle("Projections Log File Viewer");
        this.CreateMenus();
        this.CreateLayout();
        this.pack();
        ((Component)this).setVisible(true);
        this.ShowDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            if (menuItem.getLabel().equals("Open File")) {
                this.ShowDialog();
            } else if (menuItem.getLabel().equals("Close")) {
                this.Close();
            }
        } else if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bOpen) {
                this.ShowDialog();
            } else if (button == this.bClose) {
                this.Close();
            }
        }
    }

    private void Close() {
        ((Component)this).setVisible(false);
        this.mainWindow.CloseLogFileViewerWindow();
        this.dispose();
    }

    public void CloseDialog() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog = null;
        }
        this.setCursor(new Cursor(3));
        if (this.logfilenum != this.oldlogfilenum) {
            this.textArea.setText(Analysis.getLogFileText(this.logfilenum));
        }
        this.setCursor(new Cursor(0));
    }

    private void CreateLayout() {
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.setLayout(gridBagLayout);
        Util.gblAdd(this, panel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        this.textArea = new LogFileViewerTextArea();
        panel.setLayout(gridBagLayout);
        this.titlePanel = new Panel();
        this.titlePanel.setBackground(Color.black);
        this.lTitle = new Label("", 1);
        this.lTitle.setForeground(Color.white);
        this.lTitle.setFont(new Font("SansSerif", 1, 16));
        this.titlePanel.add(this.lTitle);
        Util.gblAdd(panel, this.titlePanel, gridBagConstraints, 0, 0, 1, 1, 1, 0, 5, 5, 0, 5);
        Util.gblAdd(panel, this.textArea, gridBagConstraints, 0, 1, 1, 1, 1, 1, 0, 5, 5, 5);
        Panel panel2 = new Panel();
        this.bOpen = new Button("Open File");
        this.bClose = new Button("Close Window");
        this.bOpen.addActionListener(this);
        this.bClose.addActionListener(this);
        panel2.add(this.bOpen);
        panel2.add(this.bClose);
        Util.gblAdd(panel, panel2, gridBagConstraints, 0, 2, 1, 1, 1, 0, 0, 5, 5, 5);
    }

    private void CreateMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Open File", null, "Close"}, this));
        Menu menu = new Menu("Help");
        menuBar.add(Util.makeMenu(menu, new Object[]{"Index", "About"}, this));
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
    }

    public void setLogFileNum(int n) {
        this.logfilenum = n;
        this.lTitle.setText("LOG FILE FOR PROCESSOR " + n);
        this.lTitle.invalidate();
        this.titlePanel.validate();
    }

    private void ShowDialog() {
        this.oldlogfilenum = this.logfilenum;
        if (this.dialog == null) {
            this.dialog = new LogFileViewerDialog(this);
        }
        ((Component)this.dialog).setVisible(true);
    }
}

