/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.Analysis;
import projections.gui.ColorMap;
import projections.gui.ScalePanel;
import projections.gui.ScaleSlider;
import projections.gui.StlPanel;

public class StlWindow
extends Frame
implements MouseListener,
ActionListener,
ScalePanel.StatusDisplay {
    private ScaleSlider hor;
    private ScaleSlider ver;
    private ScalePanel scalePanel;
    private StlPanel stl;
    private Label status;

    public StlWindow() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StlWindow.this.dispose();
            }
        });
        ((Component)this).setBackground(Color.black);
        this.setTitle("Projections-- Overview");
        this.createMenus();
        this.createLayout();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void createLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.status = new Label("");
        this.add((Component)this.status, gridBagConstraints);
        this.status.setBackground(Color.black);
        this.status.setForeground(Color.lightGray);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.hor = new ScaleSlider(0);
        this.add((Component)this.hor, gridBagConstraints);
        this.hor.addMouseListener(this);
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.ver = new ScaleSlider(1);
        this.add((Component)this.ver, gridBagConstraints);
        this.ver.addMouseListener(this);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.stl = new StlPanel();
        ScalePanel scalePanel = new ScalePanel(this.hor, this.ver, this.stl);
        this.add((Component)scalePanel, gridBagConstraints);
        scalePanel.setStatusDisplay(this);
        ColorMap colorMap = new ColorMap();
        colorMap.addBreak(0, 0, 0, 55, 70, 255, 0, 0);
        colorMap.addBreak(70, 255, 0, 0, 100, 255, 255, 255);
        colorMap.addBreak(101, 0, 255, 0, 255, 0, 255, 0);
        this.stl.setColorMap(colorMap.getColorModel());
        this.stl.setData(7000);
        double d = Analysis.getTotalTime();
        double d2 = Analysis.getNumProcessors();
        scalePanel.setScales(d, d2);
        double d3 = scalePanel.toSlider(1.0 / d);
        double d4 = scalePanel.toSlider(0.01);
        this.hor.setMin(d3);
        this.hor.setMax(d4);
        this.hor.setValue(d3);
        this.hor.setTicks(Math.floor(d3), 1.0);
        double d5 = scalePanel.toSlider(1.0 / d2);
        double d6 = scalePanel.toSlider(1.0);
        this.ver.setMin(d5);
        this.ver.setMax(d6);
        this.ver.setValue(d5);
        this.ver.setTicks(Math.floor(d5), 1.0);
    }

    private void createMenus() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        Component component = mouseEvent.getComponent();
        if (component == this.hor) {
            this.setStatus("Click or drag to set the horizontal zoom");
        }
        if (component == this.ver) {
            this.setStatus("Click or drag to set the vertical zoom");
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setStatus("");
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void setStatus(String string) {
        this.status.setText(string);
    }
}

