#include "SimJob.h"
#include "heap.h"

extern double time;
extern minHeap * h;
extern int systemJobType;

extern Random *minpe, *workgen; 

int maxid = 0;          //!!Change later.

#include <math.h>
#define PI 3.1416

int SimJob::speedup(int p){
    return p;
    //return (int)ceil(p *tan(PI*(0.25 - p/(24*num_system_proc))));
}

SimJob::SimJob(int np) : Job(np){

    arrivalTime = time;
    startTime = 0.0;

    previousEventTime = time;
    count = 0;
    
    max_proc = num_system_proc;

    switch(systemJobType){
    case MIGRATABLE:
	min_proc = ((int)minpe->rand()) % num_system_proc + 1;
	type = 0;
	break;
	
    case NON_MIGRATABLE:
	min_proc = ((int)minpe->rand()) % num_system_proc + 1;
	type = 2;
	break;
	
    case CONVENTIONAL:
	min_proc = ((int)minpe->rand()) % num_system_proc + 1;
	max_proc = min_proc ;//= (num_system_proc + min_proc)/2;
	type = 2;
	break;
    }

    //work = min_proc * workgen->rand();     //CHECK!!!
    work =  num_system_proc * workgen->rand();
    completionTime = time + work;
    dbid = maxid++;
}

int SimJob::updateWork(){

    work -= speedup(num_allocated_proc) * (time - previousEventTime);
    if(work < 0.0)
	work = 0.0;               //just in case due to precision problems.
    previousEventTime = time;
}

int SimJob::updateCompletionTime(){

    if(speedup(num_allocated_proc) == 0){
	printf("DIVIDE BY 0, %d\n", num_allocated_proc);
	exit(1);
    }

    completionTime = time + work/speedup(num_allocated_proc);

    //schedule event for that time;

    count ++;
    Event * e = new Event();
    e->job = this;
    e->timeStamp = completionTime;
    e->eventType = JOBDONE;
    e->count = count;
    h->insert(e);
}



