#include "heap.h"
#include "scheduler.h"
#include "iostream.h"

int MAX_JOBS = 10000;

Scheduler * scheduler;
minHeap * h;
double time;
double responseTime = 0.0;
double finishTime = 0.0;

int systemJobType = 0;
int njobs = 0;

Random *arrival, *minpe, *workgen; 

void generateArrival() {

    if(njobs > MAX_JOBS)
	return;

    njobs ++;
    Event * e = new Event();
    
    e->timeStamp = time + arrival->rand();

    e->eventType = ARRIVAL;
    e->job = NULL;
    e->count = 0;
    h->insert(e);
}

void processEvent(Event *e) {
    if (e->eventType == ARRIVAL){
	generateArrival();
	scheduler->handleArrival(e);
    }
    else if (e->eventType == JOBDONE) {
	if (e->job->count == e->count)
	    scheduler->handleJobDone(e);
	// else this is an obsolete completion event, obsoleted by a shrink/expand operation
    }
}

main(int argc, char **argv) {
    int nproc = 64;
    
    if(argc > 1)
	nproc = atoi(argv[1]);

    if(argc > 2)
	systemJobType = atoi(argv[2]);

    if(argc > 3)
	MAX_JOBS = atoi(argv[3]);
    
    scheduler = new Scheduler(nproc);
    h = new minHeap(1000000);
    time = 0.0;

    double arrival_rate = 1.0;
    if(argc > 4)
	arrival_rate = atof(argv[4]);

    arrival = new Random(1.0/arrival_rate, EXPONENTIAL);
    workgen = new Random(1, EXPONENTIAL);
    minpe = new Random();

    generateArrival();
    cout <<"heap elements: " << h->numElements() << endl;
    
    while (h->numElements() != 0) {
	Event *e = h->deleteMin();
	time = e->timeStamp;
	//	cout << "processing " << e->eventType << endl;
	processEvent(e);
    }

    printf("Number Of Jobs = %d\n", njobs);
    printf("Average Scheduling Delay = %5.5lf\n", responseTime/njobs);
    printf("Average Response Time = %5.5lf\n", finishTime/njobs); 
    printf("Utilization = %5.3lf\n", scheduler->utilization);
    printf("Time of Last Event = %5.3lf\n", time);
    printf("queue size = %5.5lf\n", scheduler->qsize);
}



