/*****************************************************************************
 * $Source: /expand6/cvsroot/charm/src/Common/xlat-i/sdag/CLexer.C,v $
 * $Author: milind $
 * $Date: 2001/03/29 10:53:28 $
 * $Revision: 1.1 $
 *****************************************************************************/

#include "CLexer.h"
#include <stdlib.h>

extern "C" void sl_scan_string(char *);

CLexer::CLexer(char *str)
{
  lineNum = 1;
  charNum = 1;
  wsSignificant = 0;
  sl_scan_string(str);
}

CLexer::~CLexer(void)
{
}

CToken *CLexer::lookAhead(void)
{
  while(1) {
    CToken *cToken = getNextToken();
    if(cToken==0)
      return cToken;
    if(cToken->type == NEW_LINE) {
      delete cToken;
      continue;
    } else {
      char *slcopy = strdup(mysltext);
      for(int i=strlen(slcopy)-1; i>=0; i-- ) {
        charNum--;
        Unput(slcopy[i]) ;
      }
      free(slcopy);
      return cToken;
    }
  }
  return (CToken *) 0;
}

CToken *CLexer::getNextToken(void)
{
  EToken type;
  CToken *cToken;

  while(1) {
    type = sllex();
    if ((int)type == 0)
      return (CToken *) 0;
    charNum += strlen(mysltext);
    if(type == NEW_LINE) {
      lineNum++;
      charNum = 1;
      if (wsSignificant)
        return new CToken(type, mysltext);
      else
        continue;
    }
    if((type != WSPACE) || wsSignificant) {
      cToken = new CToken(type, mysltext);
      // cToken->print(0);
      return cToken;
    }
  }
}

CToken *CLexer::getMatchedCode(const char *start_str, EToken stok, EToken etok)
{
  CToken *code = new CToken(MATCHED_CPP_CODE, start_str);
  int currentScope = 1;
  wsSignificant = 1;
  // Code to eat C++ code
  while(currentScope != 0) {
    CToken *cToken = getNextToken();
    if(cToken==0)
      return cToken;
    if(cToken->type == stok) {
      currentScope++;
    }
    if(cToken->type == etok) {
      currentScope--;
    }
    code->text->append(cToken->text->charstar());
    delete cToken;
  }
  wsSignificant = 0;
  return code;
}

CToken *CLexer::getIntExpr(EToken term)
{
  CToken *expr = new CToken(INT_EXPR, "");
  unsigned int endExpr = 0;
  unsigned int numBraces=(term==RBRACE)?1:0;
  unsigned int numParens=(term==RP)?1:0;
  unsigned int numBrackets=(term==RB)?1:0;
  wsSignificant = 1;
  while(!endExpr) {
    CToken *cToken = getNextToken();
    if(cToken==0)
      return cToken;
    switch(cToken->type) {
      case LP:
        numParens++;
        break;
      case RP:
        numParens--;
        break;
      case LB:
        numBrackets++;
        break;
      case RB:
        numBrackets--;
        break;
      case LBRACE:
        numBraces++;
        break;
      case RBRACE:
        numBraces--;
        break;
    }
    if(cToken->type == term && !numBraces && !numParens && !numBrackets) {
      for(int i=strlen(mysltext)-1; i>=0; i-- ) {
        charNum--;
        Unput(mysltext[i]) ;
      }
      endExpr = 1;
    } else {
      expr->text->append(cToken->text->charstar());
    }
    delete cToken;
  }
  wsSignificant = 0;
  return expr;
}
