/*****************************************************************************
 * $Source: /expand6/cvsroot/charm/src/Common/xlat-i/sdag/CParsedFile.h,v $
 * $Author: milind $
 * $Date: 2001/04/02 21:56:23 $
 * $Revision: 1.2 $
 *****************************************************************************/

#ifndef _CParsedFile_H_
#define _CParsedFile_H_

#include "xi-util.h"
#include "CList.h"
#include "CEntry.h"
#include "CParseNode.h"
#include "sdag-globals.h"
#include <stdio.h>

class CParsedFile {
  private:
    void numberNodes(void);
    void labelNodes(void);
    void propagateState(void);
    void generateEntryList(void);
    void generateCode(XStr& output);
    void generateEntries(XStr& output);
    void generateInitFunction(XStr& output);
  public:
    TList<CEntry*> entryList;
    TList<CParseNode*> nodeList;
    CParsedFile(void) {}
    ~CParsedFile(void){}
    void print(int indent);
    void doProcess(XStr& classname, XStr& output) {
      output << "#define " << classname << "_SDAG_CODE \n";
      numberNodes();
      labelNodes();
      propagateState();
      generateEntryList();
      generateCode(output);
      generateEntries(output);
      generateInitFunction(output);
      output.line_append('\\');
      output << "\n";
    }
};

#endif
