/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import java.util.Vector;
import projections.analysis.AsciiIntegerReader;
import projections.analysis.LogEntry;
import projections.analysis.PackTime;
import projections.analysis.ProjDefs;
import projections.analysis.StsReader;
import projections.analysis.TimelineEvent;
import projections.analysis.TimelineMessage;
import projections.analysis.ViewerEvent;
import projections.misc.EntryNotFoundException;
import projections.misc.LogLoadException;
import projections.misc.ProgressDialog;

public class LogLoader
extends ProjDefs {
    private StsReader sts;
    private long BeginTime;
    private long EndTime;

    public LogLoader(StsReader stsReader) throws LogLoadException {
        this.sts = stsReader;
        ProgressDialog progressDialog = new ProgressDialog("Finding end time...");
        this.BeginTime = 0L;
        this.EndTime = Integer.MIN_VALUE;
        int n = this.sts.getProcessorCount();
        int n2 = 0;
        while (n2 < n) {
            progressDialog.progress(n2, n, n2 + " of " + n);
            try {
                String string;
                StringTokenizer stringTokenizer;
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.sts.getLogName(n2), "r");
                long l = randomAccessFile.length() - 240L;
                if (l < 0L) {
                    l = 0L;
                }
                randomAccessFile.seek(l);
                while (randomAccessFile.readByte() != 10) {
                }
                while (Integer.parseInt((stringTokenizer = new StringTokenizer(string = randomAccessFile.readLine())).nextToken()) != 7) {
                }
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                if ((long)n3 > this.EndTime) {
                    this.EndTime = n3;
                }
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                System.out.println("Couldn't read log file " + this.sts.getLogName(n2));
            }
            ++n2;
        }
        progressDialog.done();
        this.sts.setTotalTime(this.EndTime - this.BeginTime);
    }

    public Vector createtimeline(int n, long l, long l2) throws LogLoadException {
        int n2 = 0;
        long l3 = Long.MIN_VALUE;
        boolean bl = true;
        AsciiIntegerReader asciiIntegerReader = null;
        LogEntry logEntry = null;
        TimelineEvent timelineEvent = null;
        TimelineMessage timelineMessage = null;
        PackTime packTime = null;
        Vector<TimelineEvent> vector = null;
        System.gc();
        try {
            vector = new Vector<TimelineEvent>();
            asciiIntegerReader = new AsciiIntegerReader(new BufferedReader(new FileReader(this.sts.getLogName(n))));
            asciiIntegerReader.nextLine();
            while (true) {
                logEntry = this.readlogentry(asciiIntegerReader);
                if (logEntry.Entry == -1) continue;
                if (logEntry.TransactionType == 2 && logEntry.Entry != -1) {
                    l3 = (long)logEntry.Time - this.BeginTime;
                    n2 = logEntry.Entry;
                } else if (logEntry.TransactionType == 14) {
                    l3 = (long)logEntry.Time - this.BeginTime;
                }
                if ((long)logEntry.Time >= l) break;
            }
            if ((long)logEntry.Time > l2) {
                switch (logEntry.TransactionType) {
                    case 2: {
                        System.out.println("finished empty timeline for " + n);
                        asciiIntegerReader.close();
                        return vector;
                    }
                }
                System.out.println("overlaid, end");
                timelineEvent = new TimelineEvent(l - this.BeginTime, l2 - this.BeginTime, logEntry.Entry, logEntry.Pe);
                vector.addElement(timelineEvent);
                asciiIntegerReader.close();
                return vector;
            }
            do {
                if (logEntry.Entry != -1) {
                    switch (logEntry.TransactionType) {
                        case 2: {
                            timelineEvent = new TimelineEvent((long)logEntry.Time - this.BeginTime, Long.MAX_VALUE, logEntry.Entry, logEntry.Pe);
                            vector.addElement(timelineEvent);
                            break;
                        }
                        case 3: {
                            if (timelineEvent != null) {
                                timelineEvent.EndTime = (long)logEntry.Time - this.BeginTime;
                            }
                            timelineEvent = null;
                            break;
                        }
                        case 1: {
                            if (timelineEvent == null) {
                                timelineEvent = new TimelineEvent(l3, Long.MAX_VALUE, n2, logEntry.Pe);
                                vector.addElement(timelineEvent);
                            }
                            timelineMessage = new TimelineMessage((long)logEntry.Time - this.BeginTime, logEntry.Entry);
                            timelineEvent.addMessage(timelineMessage);
                            break;
                        }
                        case 13: {
                            if (timelineEvent == null) {
                                timelineEvent = new TimelineEvent(l3, Long.MAX_VALUE, n2, logEntry.Pe);
                                vector.addElement(timelineEvent);
                            }
                            timelineMessage = new TimelineMessage((long)logEntry.Time - this.BeginTime, -logEntry.MsgType);
                            timelineEvent.addMessage(timelineMessage);
                            break;
                        }
                        case 16: {
                            if (timelineEvent == null) {
                                timelineEvent = new TimelineEvent(l3, Long.MAX_VALUE, n2, logEntry.Pe);
                                vector.addElement(timelineEvent);
                            }
                            packTime = new PackTime(logEntry.Time);
                            timelineEvent.addPack(packTime);
                            break;
                        }
                        case 17: {
                            if (packTime != null) {
                                packTime.EndTime = logEntry.Time;
                            }
                            packTime = null;
                            break;
                        }
                        case 14: {
                            timelineEvent = new TimelineEvent((long)logEntry.Time - this.BeginTime, Long.MAX_VALUE, -1, -1);
                            vector.addElement(timelineEvent);
                            break;
                        }
                        case 15: {
                            if (timelineEvent != null) {
                                timelineEvent.EndTime = (long)logEntry.Time - this.BeginTime;
                            }
                            timelineEvent = null;
                        }
                    }
                }
                logEntry = this.readlogentry(asciiIntegerReader);
            } while ((long)logEntry.Time - this.BeginTime <= l2);
            while (timelineEvent != null) {
                if (logEntry.TransactionType == 3) {
                    timelineEvent.EndTime = (long)logEntry.Time - this.BeginTime;
                    timelineEvent = null;
                }
                logEntry = this.readlogentry(asciiIntegerReader);
            }
            asciiIntegerReader.close();
        }
        catch (EOFException eOFException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + this.sts.getLogName(n));
        }
        catch (IOException iOException) {
            throw new LogLoadException(this.sts.getLogName(n), 1);
        }
        return vector;
    }

    private ViewerEvent entrytotext(LogEntry logEntry, StsReader stsReader) {
        ViewerEvent viewerEvent = new ViewerEvent();
        viewerEvent.Time = (long)logEntry.Time - this.BeginTime;
        viewerEvent.EventType = logEntry.TransactionType;
        switch (logEntry.TransactionType) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                return viewerEvent;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (logEntry.Entry != -1 && logEntry.Entry != -1) {
                    String[][] stringArray = stsReader.getEntryNames();
                    viewerEvent.Dest = new String(stringArray[logEntry.Entry][1] + "::" + stringArray[logEntry.Entry][0]);
                    if (logEntry.TransactionType != 1) {
                        viewerEvent.SrcPe = logEntry.Pe;
                    }
                    return viewerEvent;
                }
                return null;
            }
        }
        return null;
    }

    LogEntry readlogentry(AsciiIntegerReader asciiIntegerReader) throws IOException {
        LogEntry logEntry = new LogEntry();
        logEntry.TransactionType = asciiIntegerReader.nextInt();
        switch (logEntry.TransactionType) {
            case 13: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                logEntry.Time = asciiIntegerReader.nextInt();
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                logEntry.Time = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 1: 
            case 2: 
            case 3: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                logEntry.Entry = asciiIntegerReader.nextInt();
                logEntry.Time = asciiIntegerReader.nextInt();
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 4: 
            case 5: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                logEntry.Time = asciiIntegerReader.nextInt();
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 10: 
            case 11: 
            case 12: {
                logEntry.MsgType = asciiIntegerReader.nextInt();
                logEntry.Time = asciiIntegerReader.nextInt();
                logEntry.Time = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 8: 
            case 9: {
                logEntry.Time = asciiIntegerReader.nextInt();
                logEntry.EventID = asciiIntegerReader.nextInt();
                logEntry.Pe = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 6: {
                logEntry.Time = asciiIntegerReader.nextInt();
                return logEntry;
            }
            case 7: {
                logEntry.Time = asciiIntegerReader.nextInt();
                return logEntry;
            }
        }
        System.out.println("ERROR: weird event type " + logEntry.TransactionType);
        return logEntry;
    }

    public long searchtimeline(int n, int n2, int n3) throws LogLoadException, EntryNotFoundException {
        long l = 0L;
        LogEntry logEntry = null;
        AsciiIntegerReader asciiIntegerReader = null;
        System.out.println("looking through log for processor " + n);
        try {
            System.gc();
            asciiIntegerReader = new AsciiIntegerReader(new BufferedReader(new FileReader(this.sts.getLogName(n))));
            asciiIntegerReader.nextLine();
            while (true) {
                logEntry = this.readlogentry(asciiIntegerReader);
                if (logEntry.Entry == -1) continue;
                if (logEntry.Entry == n2 && logEntry.TransactionType == 2) {
                    ++l;
                }
                if (l > (long)n3) break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + this.sts.getLogName(n));
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            throw new LogLoadException(this.sts.getLogName(n), 1);
        }
        return (long)logEntry.Time - this.BeginTime;
    }

    public Vector view(int n) throws LogLoadException {
        AsciiIntegerReader asciiIntegerReader = null;
        Vector<ViewerEvent> vector = null;
        try {
            vector = new Vector<ViewerEvent>();
            asciiIntegerReader = new AsciiIntegerReader(new BufferedReader(new FileReader(this.sts.getLogName(n))));
            asciiIntegerReader.nextLine();
            while (true) {
                ViewerEvent viewerEvent;
                if ((viewerEvent = this.entrytotext(this.readlogentry(asciiIntegerReader), this.sts)) == null) {
                    continue;
                }
                vector.addElement(viewerEvent);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR: couldn't open file " + this.sts.getLogName(n));
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            System.out.println("throwing....2");
            throw new LogLoadException(this.sts.getLogName(n), 1);
        }
        return vector;
    }
}

