/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.ColorWindowFrame;
import projections.gui.Util;

public class ColorSelectWindow
extends Frame
implements AdjustmentListener,
ActionListener {
    private Label lRed;
    private Label lGreen;
    private Label lBlue;
    private Scrollbar sbRed;
    private Scrollbar sbGreen;
    private Scrollbar sbBlue;
    private DisplayCanvas displayCanvas;
    private Button bOK;
    private Button bCancel;
    private TextField tfRed;
    private TextField tfGreen;
    private TextField tfBlue;
    private Color currentColor;
    private String title;
    private int w;
    private int h;
    private Panel p1;
    private Panel p2;
    private ColorWindowFrame myParent;

    public ColorSelectWindow(ColorWindowFrame colorWindowFrame, Color color, String string) {
        this.currentColor = color;
        this.myParent = colorWindowFrame;
        this.title = string;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ColorSelectWindow.this.dispose();
            }
        });
        this.setTitle("Select Color");
        ((Component)this).setBackground(Color.gray);
        this.lRed = new Label("Red");
        this.lGreen = new Label("Green");
        this.lBlue = new Label("Blue");
        this.sbRed = new Scrollbar(0, color.getRed(), 10, 0, 265);
        this.sbGreen = new Scrollbar(0, color.getGreen(), 10, 0, 265);
        this.sbBlue = new Scrollbar(0, color.getBlue(), 10, 0, 265);
        this.sbRed.setBlockIncrement(16);
        this.sbRed.addAdjustmentListener(this);
        this.sbGreen.setBlockIncrement(16);
        this.sbGreen.addAdjustmentListener(this);
        this.sbBlue.setBlockIncrement(16);
        this.sbBlue.addAdjustmentListener(this);
        this.tfRed = new TextField("" + color.getRed(), 5);
        this.tfGreen = new TextField("" + color.getGreen(), 5);
        this.tfBlue = new TextField("" + color.getBlue(), 5);
        this.tfRed.setEditable(false);
        this.tfGreen.setEditable(false);
        this.tfBlue.setEditable(false);
        this.bOK = new Button("OK");
        this.bCancel = new Button("Cancel");
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.displayCanvas = new DisplayCanvas(color);
        this.p1 = new Panel();
        this.p1.setBackground(Color.lightGray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.p1.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(this.p1, this.displayCanvas, gridBagConstraints, 0, 0, 3, 1, 1, 1, 10, 10, 10, 10);
        Util.gblAdd(this.p1, this.lRed, gridBagConstraints, 0, 1, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.lGreen, gridBagConstraints, 0, 2, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.lBlue, gridBagConstraints, 0, 3, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.sbRed, gridBagConstraints, 1, 1, 1, 1, 1, 0);
        Util.gblAdd(this.p1, this.sbGreen, gridBagConstraints, 1, 2, 1, 1, 1, 0);
        Util.gblAdd(this.p1, this.sbBlue, gridBagConstraints, 1, 3, 1, 1, 1, 0);
        Util.gblAdd(this.p1, this.tfRed, gridBagConstraints, 2, 1, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.tfGreen, gridBagConstraints, 2, 2, 1, 1, 0, 0, 0, 2, 0, 2);
        Util.gblAdd(this.p1, this.tfBlue, gridBagConstraints, 2, 3, 1, 1, 0, 0, 0, 2, 0, 2);
        this.p2 = new Panel();
        this.p2.setBackground(Color.lightGray);
        this.p2.setLayout(new FlowLayout());
        this.p2.add(this.bOK);
        this.p2.add(this.bCancel);
        this.setLayout(new GridBagLayout());
        Util.gblAdd(this, this.p1, gridBagConstraints, 0, 1, 1, 1, 1, 1, 2, 2, 2, 2);
        Util.gblAdd(this, this.p2, gridBagConstraints, 0, 2, 1, 1, 1, 0, 2, 2, 2, 2);
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Button button = (Button)actionEvent.getSource();
        if (button == this.bOK) {
            this.myParent.applyNewColor(this.currentColor);
        }
        this.dispose();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = this.sbRed.getValue();
        int n2 = this.sbGreen.getValue();
        int n3 = this.sbBlue.getValue();
        this.tfRed.setText("" + n);
        this.tfGreen.setText("" + n2);
        this.tfBlue.setText("" + n3);
        this.currentColor = new Color(n, n2, n3);
        this.displayCanvas.setColor(this.currentColor);
    }

    public void setColor(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        this.sbRed.setValue(n);
        this.sbGreen.setValue(n2);
        this.sbBlue.setValue(n3);
        this.tfRed.setText("" + n);
        this.tfGreen.setText("" + n2);
        this.tfBlue.setText("" + n3);
        this.currentColor = color;
        this.displayCanvas.setColor(color);
    }

    public void setString(String string) {
        this.displayCanvas.setString(string);
    }

    private class DisplayCanvas
    extends Canvas {
        private Color foreground;
        int w;
        int h;
        private FontMetrics fm;
        private int titleHeight;
        private int titleWidth;

        public DisplayCanvas(Color color) {
            this.foreground = color;
            this.setBackground(Color.black);
        }

        public Dimension getMinimumSize() {
            return new Dimension(150, 50);
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, 75);
        }

        public void setColor(Color color) {
            this.foreground = color;
            this.repaint();
        }

        public void setString(String string) {
            ColorSelectWindow.this.title = string;
            this.titleWidth = this.fm.stringWidth(ColorSelectWindow.this.title);
            Graphics graphics = this.getGraphics();
            graphics.clearRect(0, 0, this.w, this.h);
            this.repaint();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            if (this.fm == null) {
                this.fm = graphics.getFontMetrics(graphics.getFont());
                this.titleHeight = this.fm.getHeight();
                this.titleWidth = this.fm.stringWidth(ColorSelectWindow.this.title);
            }
            this.w = this.getSize().width;
            this.h = this.getSize().height;
            graphics.setColor(this.foreground);
            graphics.drawString(ColorSelectWindow.this.title, (this.w - this.titleWidth) / 2, this.titleHeight);
            graphics.drawLine(0, this.h, this.w / 2, this.titleHeight + 10);
            graphics.fillRect(this.w / 2 + 20, this.h / 2, this.w / 4, this.h / 2);
            graphics.setColor(Color.gray);
            graphics.drawLine(0, 0, this.w, 0);
            graphics.drawLine(0, 1, this.w, 1);
            graphics.drawLine(0, 0, 0, this.h);
            graphics.drawLine(1, 0, 1, this.h);
            graphics.setColor(Color.white);
            graphics.drawLine(0, this.h, this.w, this.h);
            graphics.drawLine(0, this.h - 1, this.w, this.h - 1);
            graphics.drawLine(this.w, this.h, this.w, 0);
            graphics.drawLine(this.w - 1, this.h, this.w - 1, 0);
        }
    }
}

