/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import projections.gui.Analysis;
import projections.gui.GraphAttributesWindow;
import projections.gui.GraphControlPanel;
import projections.gui.GraphData;
import projections.gui.GraphDisplayPanel;
import projections.gui.GraphIntervalDialog;
import projections.gui.GraphLegendPanel;
import projections.gui.MainWindow;
import projections.gui.U;
import projections.gui.Util;

public class GraphWindow
extends Frame
implements ActionListener {
    private MainWindow mainWindow;
    private GraphDisplayPanel displayPanel;
    private GraphControlPanel controlPanel;
    private GraphLegendPanel legendPanel;
    private GraphAttributesWindow attributesWindow;
    private GraphIntervalDialog intervalDialog;
    private GraphData data;
    private int numintervals = -1;
    private long intervalsize;
    private int w;
    private int h;
    private boolean firstTime = true;

    public GraphWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphWindow.this.Close();
            }
        });
        ((Component)this).setBackground(Color.lightGray);
        this.CreateLayout();
        this.CreateMenus();
        this.pack();
        this.setTitle("Projections Graph");
        ((Component)this).setVisible(true);
        this.ShowIntervalDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getLabel();
            if (string.equals("Close")) {
                this.Close();
            } else if (string.equals("Export Data")) {
                this.ExportData();
            } else if (string.equals("Print Graph")) {
                this.PrintGraph();
            } else if (string.equals("Set Interval Size")) {
                this.ShowIntervalDialog();
            } else if (string.equals("Timeline")) {
                this.mainWindow.ShowTimelineWindow();
            } else if (string.equals("Index")) {
                this.mainWindow.ShowHelpWindow();
            } else if (string.equals("About")) {
                this.mainWindow.ShowAboutDialog(this);
            }
        }
    }

    private void Close() {
        if (this.legendPanel != null) {
            this.legendPanel.closeAttributesWindow();
        }
        ((Component)this).setVisible(false);
        this.dispose();
        this.mainWindow.CloseGraphWindow();
    }

    private void CreateLayout() {
        Panel panel = new Panel();
        this.add("Center", panel);
        panel.setBackground(Color.gray);
        this.displayPanel = new GraphDisplayPanel();
        this.controlPanel = new GraphControlPanel();
        this.legendPanel = new GraphLegendPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(panel, this.displayPanel, gridBagConstraints, 0, 0, 1, 1, 2, 1, 2, 2, 2, 2);
        Util.gblAdd(panel, this.legendPanel, gridBagConstraints, 1, 0, 1, 1, 1, 1, 2, 2, 2, 2);
        Util.gblAdd(panel, this.controlPanel, gridBagConstraints, 0, 1, 2, 1, 1, 0, 2, 2, 2, 2);
    }

    private void CreateMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Export Data", "Print Graph", null, "Close"}, this));
        menuBar.add(Util.makeMenu("Tools", new Object[]{"Set Interval Size", "Timeline"}, this));
        Menu menu = new Menu("Help");
        menuBar.add(Util.makeMenu(menu, new Object[]{"Index", "About"}, this));
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
    }

    private void ExportData() {
        if (this.data == null) {
            return;
        }
        System.out.println("Exporting Data");
        FileDialog fileDialog = new FileDialog((Frame)this, "Select save file", 1);
        fileDialog.setDirectory(".");
        fileDialog.setFile("");
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string == null) {
            return;
        }
        string = fileDialog.getDirectory() + string;
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(string)));
            bufferedWriter.write("# PROJECTIONS GRAPH for " + Analysis.getFilename());
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("# X-AXIS = ");
            if (this.data.xmode == 1) {
                bufferedWriter.write("Intervals");
            } else if (this.data.xmode == 0) {
                bufferedWriter.write("Procesors");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Y-AXIS = ");
            if (this.data.ymode == 11) {
                bufferedWriter.write("Messages");
            } else if (this.data.ymode == 10) {
                bufferedWriter.write("Time");
            }
            bufferedWriter.newLine();
            bufferedWriter.write("# Data is shown for ");
            if (this.data.xmode == 1) {
                bufferedWriter.write("processors " + this.data.processor.string);
            } else if (this.data.xmode == 0) {
                bufferedWriter.write("intervals " + this.data.interval.string);
            }
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("# Number of intervals = " + this.numintervals);
            bufferedWriter.newLine();
            bufferedWriter.write("# Interval size = " + U.t(this.intervalsize));
            bufferedWriter.newLine();
            bufferedWriter.write("# Number of Processors = " + Analysis.getNumProcessors());
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("# UNITS IN LEGEND:");
            bufferedWriter.newLine();
            bufferedWriter.write("# \t% = percentage");
            bufferedWriter.newLine();
            bufferedWriter.write("# \tM = messages");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("# LEGEND: (units) Item Name");
            bufferedWriter.newLine();
            int n = 0;
            int n2 = 0;
            while (n2 < this.data.onGraph.length) {
                if (this.data.onGraph[n2].ymode == this.data.ymode || this.data.onGraph[n2].ymode == 12) {
                    bufferedWriter.write("#\t" + n + "\t= ");
                    if (this.data.onGraph[n2].ymode == 11) {
                        bufferedWriter.write("(M)\t");
                    } else if (this.data.onGraph[n2].ymode == 10) {
                        bufferedWriter.write("(T)\t");
                    } else if (this.data.onGraph[n2].ymode == 12) {
                        bufferedWriter.write("(%)\t");
                    }
                    if (this.data.onGraph[n2].parent != null) {
                        bufferedWriter.write(this.data.onGraph[n2].parent + "::");
                    }
                    bufferedWriter.write(this.data.onGraph[n2].name);
                    if (!this.data.onGraph[n2].type.equals("%") && !this.data.onGraph[n2].type.equals("Msgs")) {
                        bufferedWriter.write(" " + this.data.onGraph[n2].type);
                    }
                    bufferedWriter.newLine();
                    ++n;
                }
                ++n2;
            }
            if (this.data.xmode == 1) {
                bufferedWriter.newLine();
                bufferedWriter.write("# DATA BY INTERVAL");
                bufferedWriter.newLine();
                bufferedWriter.write("#\tFirst column = interval number");
                bufferedWriter.newLine();
                bufferedWriter.write("#\tFirst row = legend index");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            } else if (this.data.xmode == 0) {
                bufferedWriter.newLine();
                bufferedWriter.write("# DATA BY PROCESSOR");
                bufferedWriter.newLine();
                bufferedWriter.write("#\tFirst column = processor number");
                bufferedWriter.newLine();
                bufferedWriter.write("#\tFirst row = legend index");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
            bufferedWriter.write(" ");
            int n3 = 0;
            while (n3 < n) {
                bufferedWriter.write("\t" + n3);
                ++n3;
            }
            bufferedWriter.newLine();
            if (this.data.xmode == 1) {
                int n4 = 0;
                while (n4 < this.numintervals) {
                    bufferedWriter.write("" + n4);
                    int n5 = 0;
                    while (n5 < this.data.onGraph.length) {
                        if (this.data.onGraph[n5].ymode == this.data.ymode || this.data.onGraph[n5].ymode == 12) {
                            bufferedWriter.write("\t" + this.data.onGraph[n5].curIData[n4]);
                        }
                        ++n5;
                    }
                    bufferedWriter.newLine();
                    ++n4;
                }
            } else if (this.data.xmode == 0) {
                int n6 = 0;
                while (n6 < Analysis.getNumProcessors()) {
                    bufferedWriter.write("" + n6);
                    int n7 = 0;
                    while (n7 < this.data.onGraph.length) {
                        if (this.data.onGraph[n7].ymode == this.data.ymode || this.data.onGraph[n7].ymode == 12) {
                            bufferedWriter.write("\t" + this.data.onGraph[n7].curPData[n6]);
                        }
                        ++n7;
                    }
                    bufferedWriter.newLine();
                    ++n6;
                }
            }
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("ERROR WRITING TO FILE " + string);
        }
    }

    public Color getGraphColor(int n) {
        if (this.data != null && this.data.userEntry != null) {
            return this.data.userEntry[n][0].color;
        }
        return null;
    }

    public long getIntervalSize() {
        return this.intervalsize;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    private void PrintGraph() {
        PrintJob printJob = this.getToolkit().getPrintJob(this, "Print Graph", null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            this.displayPanel.PrintGraph(graphics, printJob);
            graphics.dispose();
            Graphics graphics2 = printJob.getGraphics();
            this.legendPanel.PrintLegend(graphics2, printJob);
            graphics2.dispose();
            printJob.end();
        }
    }

    private void setChildDatas() {
        this.controlPanel.setGraphData(this.data);
        this.displayPanel.setGraphData(this.data);
        this.legendPanel.setGraphData(this.data);
        this.data.graphWindow = this;
        this.data.controlPanel = this.controlPanel;
        this.data.displayPanel = this.displayPanel;
        this.data.legendPanel = this.legendPanel;
    }

    public void setIntervalSize(long l) {
        this.intervalsize = l;
    }

    public void setNumIntervals(int n) {
        this.numintervals = n;
    }

    private void ShowIntervalDialog() {
        int n = this.numintervals;
        this.intervalDialog = new GraphIntervalDialog(this, this.numintervals);
        ((Component)this.intervalDialog).setVisible(true);
        this.intervalDialog = null;
        if (this.numintervals != n) {
            this.setCursor(new Cursor(3));
            Dialog dialog = new Dialog(this, "Loading data...", false);
            dialog.setLayout(new GridLayout(2, 1));
            dialog.add(new Label("Please wait while your data", 1));
            dialog.add(new Label("is loaded and analyzed", 1));
            dialog.pack();
            ((Component)dialog).setLocation((this.w - dialog.getSize().width) / 2, (this.h - dialog.getSize().height) / 2);
            ((Component)dialog).setVisible(true);
            Analysis.LoadGraphData(this.numintervals, this.intervalsize, true);
            if (this.data == null) {
                this.data = new GraphData(this.numintervals, this.intervalsize);
                this.setChildDatas();
            } else {
                this.data.initData(this.numintervals, this.intervalsize);
            }
            this.controlPanel.setXMode(this.data.xmode);
            this.controlPanel.setYMode(this.data.ymode);
            ((Component)dialog).setVisible(false);
            dialog.dispose();
            this.legendPanel.UpdateLegend();
            this.displayPanel.setAllBounds();
            this.displayPanel.UpdateDisplay();
            this.setCursor(new Cursor(0));
        }
    }
}

