/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import projections.gui.AboutDialog;
import projections.gui.Analysis;
import projections.gui.AnimationWindow;
import projections.gui.GraphWindow;
import projections.gui.HelpWindow;
import projections.gui.HistogramWindow;
import projections.gui.InvalidFileDialog;
import projections.gui.LogFileViewerWindow;
import projections.gui.MainButtonPanel;
import projections.gui.MainTitlePanel;
import projections.gui.ProfileWindow;
import projections.gui.StlWindow;
import projections.gui.TimelineWindow;
import projections.gui.Util;

public class MainWindow
extends Frame
implements ActionListener {
    private GraphWindow graphWindow;
    private TimelineWindow timelineWindow;
    private AnimationWindow animationWindow;
    private ProfileWindow profileWindow;
    private HelpWindow helpWindow;
    private LogFileViewerWindow logFileViewerWindow;
    private HistogramWindow histogramWindow;
    private StlWindow stlWindow;
    private AboutDialog aboutDialog;
    private MainTitlePanel titlePanel;
    private MainButtonPanel buttonPanel;
    private boolean toolsEnabled = false;
    private Image paper;
    private Image bgimage;

    public MainWindow() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ((Component)this).setBackground(Color.lightGray);
        this.CreateMenus();
        this.CreateLayout();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)actionEvent.getSource();
            String string = menuItem.getLabel();
            if (string.equals("Open...")) {
                this.ShowOpenFileDialog();
            } else if (string.equals("Quit")) {
                System.exit(0);
            } else if (string.equals("Index")) {
                this.ShowHelpWindow();
            } else if (string.equals("About")) {
                this.ShowAboutDialog(this);
            } else if (this.toolsEnabled) {
                if (string.equals("Graphs")) {
                    this.ShowGraphWindow();
                } else if (string.equals("Timelines")) {
                    this.ShowTimelineWindow();
                } else if (string.equals("Animations")) {
                    this.ShowAnimationWindow();
                } else if (string.equals("Usage Profile")) {
                    this.ShowProfileWindow();
                } else if (string.equals("View Log Files")) {
                    this.ShowLogFileViewerWindow();
                } else if (string.equals("Histograms")) {
                    this.ShowHistogramWindow();
                } else if (string.equals("Overview")) {
                    this.ShowStlWindow();
                }
            }
        }
    }

    public void CloseGraphWindow() {
        this.graphWindow = null;
    }

    public void CloseHistogramWindow() {
        if (this.histogramWindow != null) {
            this.histogramWindow = null;
        }
    }

    public void CloseLogFileViewerWindow() {
        if (this.logFileViewerWindow != null) {
            this.logFileViewerWindow = null;
        }
    }

    public void CloseProfileWindow() {
        this.profileWindow = null;
    }

    public void CloseTimelineWindow() {
        this.timelineWindow = null;
    }

    private void CreateLayout() {
        Serializable serializable;
        try {
            serializable = this.getClass().getResource("/projections/images/bgimage");
            this.bgimage = Toolkit.getDefaultToolkit().getImage((URL)serializable);
            Util.waitForImage(this, this.bgimage);
        }
        catch (Exception exception) {
            System.out.println("Error loading background image.  Continuing.");
        }
        serializable = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.setLayout((LayoutManager)((Object)serializable));
        this.titlePanel = new MainTitlePanel(this);
        this.buttonPanel = new MainButtonPanel(this);
        Util.gblAdd(this, this.titlePanel, gridBagConstraints, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0);
        Util.gblAdd(this, this.buttonPanel, gridBagConstraints, 0, 1, 1, 1, 1, 0, 10, 10, 10, 10);
        this.pack();
    }

    private void CreateMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Open...", null, "Quit"}, this));
        menuBar.add(Util.makeMenu("View", new Object[]{new CheckboxMenuItem("WindowShade")}, this));
        menuBar.add(Util.makeMenu("Tools", new Object[]{"Graphs", "Timelines", "Usage Profile", "Animations", "View Log Files", "Histograms", "Overview"}, this));
        Menu menu = Util.makeMenu("Help", new Object[]{"Index", "About"}, this);
        menuBar.add(menu);
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
    }

    public Color getGraphColor(int n) {
        if (this.graphWindow != null) {
            return this.graphWindow.getGraphColor(n);
        }
        return null;
    }

    public boolean GraphExists() {
        return this.graphWindow != null;
    }

    public static void main(String[] stringArray) {
        MainWindow mainWindow = new MainWindow();
        mainWindow.pack();
        mainWindow.setTitle("Projections");
        mainWindow.setResizable(false);
        ((Component)mainWindow).setVisible(true);
    }

    public void paint(Graphics graphics) {
        if (this.bgimage != null) {
            Util.wallPaper(this, graphics, this.bgimage);
        }
        super.paint(graphics);
    }

    public void ShowAboutDialog(Frame frame) {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(frame);
        }
        ((Component)this.aboutDialog).setVisible(true);
    }

    public void ShowAnimationWindow() {
        if (this.animationWindow == null) {
            new Thread(new Runnable(){

                public void run() {
                    MainWindow.this.animationWindow = new AnimationWindow();
                    ((Component)MainWindow.this.animationWindow).setVisible(true);
                }
            }).start();
        }
    }

    public void ShowGraphWindow() {
        if (this.graphWindow == null) {
            this.graphWindow = new GraphWindow(this);
        }
    }

    public void ShowHelpWindow() {
        if (this.helpWindow == null) {
            this.helpWindow = new HelpWindow(this);
        }
        ((Component)this.helpWindow).setVisible(true);
    }

    public void ShowHistogramWindow() {
        if (this.histogramWindow == null) {
            this.histogramWindow = new HistogramWindow(this);
        }
        ((Component)this.histogramWindow).setVisible(true);
    }

    public void ShowLogFileViewerWindow() {
        if (this.logFileViewerWindow == null) {
            this.logFileViewerWindow = new LogFileViewerWindow(this);
        }
        ((Component)this.logFileViewerWindow).setVisible(true);
    }

    public void ShowOpenFileDialog() {
        this.buttonPanel.disableButtons();
        FileDialog fileDialog = new FileDialog((Frame)this, "Select .sts file to load", 0);
        fileDialog.setDirectory(".");
        fileDialog.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".sts");
            }
        });
        fileDialog.setFile("pgm.sts");
        ((Component)fileDialog).setVisible(true);
        String string = fileDialog.getFile();
        if (string == null) {
            return;
        }
        string = fileDialog.getDirectory() + string;
        try {
            string = string.substring(0, string.length() - 4);
            Analysis.initAnalysis(string);
            this.toolsEnabled = true;
            this.buttonPanel.enableButtons();
        }
        catch (IOException iOException) {
            InvalidFileDialog invalidFileDialog = new InvalidFileDialog(null);
            ((Component)invalidFileDialog).setVisible(true);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            InvalidFileDialog invalidFileDialog = new InvalidFileDialog(null);
            ((Component)invalidFileDialog).setVisible(true);
        }
    }

    public void ShowProfileWindow() {
        if (this.profileWindow == null) {
            this.profileWindow = new ProfileWindow(this, null);
        }
        ((Component)this.profileWindow).setVisible(true);
    }

    public void ShowStlWindow() {
        new Thread(new Runnable(){

            public void run() {
                MainWindow.this.stlWindow = new StlWindow();
            }
        }).start();
    }

    public void ShowTimelineWindow() {
        if (this.timelineWindow == null) {
            this.timelineWindow = new TimelineWindow(this);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

