/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

public class OrderedIntList {
    private Link head;
    private Link tail;
    private Link pre;
    private int len;

    public OrderedIntList copyOf() {
        int n;
        OrderedIntList orderedIntList = new OrderedIntList();
        this.reset();
        while ((n = this.nextElement()) != -1) {
            orderedIntList.insert(n);
        }
        return orderedIntList;
    }

    public int currentElement() {
        Link link = this.nextLink();
        if (link == null) {
            return -1;
        }
        return link.data;
    }

    public boolean equals(OrderedIntList orderedIntList) {
        int n;
        if (orderedIntList == null) {
            return false;
        }
        if (this.size() != orderedIntList.size()) {
            return false;
        }
        this.reset();
        orderedIntList.reset();
        while ((n = this.nextElement()) != -1) {
            if (orderedIntList.nextElement() == n) continue;
            return false;
        }
        return true;
    }

    public boolean hasMoreElements() {
        return this.nextLink() != null;
    }

    public void insert(int n) {
        this.reset();
        Link link = this.nextLink();
        while (link != null && link.data < n) {
            this.pre = link;
            link = this.nextLink();
        }
        if (link == null) {
            Link link2 = new Link(n, link);
            if (this.head == null) {
                this.head = link2;
                this.tail = link2;
            } else {
                this.pre.next = link2;
                this.tail = link2;
            }
            ++this.len;
        } else if (link.data != n) {
            Link link3 = new Link(n, link);
            if (this.head == link) {
                this.head = link3;
            } else {
                this.pre.next = link3;
            }
            ++this.len;
        }
    }

    public String listToString() {
        this.reset();
        int n = this.nextElement();
        String string = "";
        while (n != -1) {
            int n2 = n;
            while (this.currentElement() - n == 1) {
                n = this.nextElement();
            }
            int n3 = n;
            n = this.nextElement();
            if (!string.equals("")) {
                string = string + ",";
            }
            string = n2 == n3 ? string + n2 : string + new String("" + n2 + "-" + n3);
        }
        return string;
    }

    public int nextElement() {
        this.pre = this.pre == null ? this.head : this.pre.next;
        if (this.pre == null) {
            return -1;
        }
        return this.pre.data;
    }

    private Link nextLink() {
        if (this.pre == null) {
            return this.head;
        }
        return this.pre.next;
    }

    public void printList() {
        this.reset();
        while (this.hasMoreElements()) {
            System.out.println("" + this.nextElement());
        }
    }

    public void removeAll() {
        this.len = 0;
        this.head = null;
        this.tail = null;
        this.pre = null;
    }

    public void reset() {
        this.pre = null;
    }

    public int size() {
        return this.len;
    }

    class Link {
        int data;
        Link next;

        Link(int n, Link link) {
            this.data = n;
            this.next = link;
        }
    }
}

