/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import projections.gui.TimelineData;

public class TimelineDisplayCanvas
extends Container {
    private TimelineData data;
    private Image offscreen;

    public TimelineDisplayCanvas(TimelineData timelineData) {
        this.data = timelineData;
        this.offscreen = null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 400);
    }

    public void makeNewImage() {
        if (this.data.tlh > 0 && this.data.tlw > 0) {
            try {
                this.offscreen = this.createImage(this.data.tlw, this.data.tlh);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.out.println("NOT ENOUGH MEMORY!");
                return;
            }
            if (this.offscreen == null) {
                return;
            }
            Graphics graphics = this.offscreen.getGraphics();
            graphics.setClip(0, 0, this.data.tlw, this.data.tlh);
            int n = this.data.offset + (int)((double)(this.data.endTime - this.data.beginTime) * this.data.pixelIncrement / (double)this.data.timeIncrement);
            graphics.setColor(Color.gray);
            int n2 = 0;
            while (n2 < this.data.numPs) {
                int n3 = this.data.tluh / 2 + n2 * this.data.tluh;
                graphics.drawLine(this.data.offset, n3, n, n3);
                ++n2;
            }
            super.paint(graphics);
            graphics.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen != null) {
            int n = this.data.timelineWindow.getHSBValue();
            int n2 = this.data.timelineWindow.getVSBValue();
            graphics.drawImage(this.offscreen, n, n2, n + this.data.vpw, n2 + this.data.vph, n, n2, n + this.data.vpw, n2 + this.data.vph, null);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void updateColors() {
        if (this.offscreen != null) {
            Graphics graphics = this.offscreen.getGraphics();
            super.paint(graphics);
            graphics.dispose();
            this.repaint();
        }
    }
}

