#include "rotest.h"

CkGroupID rotest_groupid;
int rotest_iarray_num[10];
int rotest_iarray_sz[ROTEST_SIZE];
rotest_msg *romsg;

void rotest_init(void)
{
  CProxy_rotest_group pgg(rotest_groupid);
  pgg.start();
}

void rotest_moduleinit(void) 
{
  int i;
  for(i=0;i<10;i++) {
    rotest_iarray_num[i] = i*i+1023;
  }
  for(i=0;i<ROTEST_SIZE;i++) {
    rotest_iarray_sz[i] = i*i+511;
  }
  romsg = new rotest_msg(1024);
  rotest_groupid = CProxy_rotest_group::ckNew();
}

static int rotest_check(void)
{
  int i;
  for(i=0;i<10;i++) {
    if(rotest_iarray_num[i] != i*i+1023)
      return 1;
  }
  for(i=0;i<ROTEST_SIZE;i++) {
    if(rotest_iarray_sz[i] != i*i+511)
      return 1;
  }
  return romsg->check();
}

void rotest_group::start(void)
{
  if(rotest_check())
    CkError("rotest failed on PE%d!\n", CkMyPe());
  CProxy_rotest_group rog(rotest_groupid);
  rog.done(0);
}

void rotest_group::done(void)
{
  numdone++;
  if(numdone == CkNumPes()) {
    numdone = 0;
    finishTest();
  }
}

#include "rotest.def.h"
