#ifndef SIM_JOB_H
#define SIM_JOB_H

#include "common.h"
#include "Random.h"

#define MIGRATABLE 0
#define NON_MIGRATABLE 1
#define CONVENTIONAL 2

class SimJob : public Job{
 public: 
    double arrivalTime;       // Time when job arrived.
    double startTime;         // Time when job started.
    double work;              // Execution time of the job on one processor.
    double previousEventTime; // Time when previous event occored.
    double completionTime;    // estimated completion time of the job.

    int count; /* how many times has the completion time been changed, due to the job shrinking or expanding */

    //    int id; using dbid for now.

    SimJob(int nproc);
    int updateWork();
    int updateCompletionTime();
    int speedup(int p);
};

#define ARRIVAL 0
#define JOBDONE 1

class Event
{
public:
   int eventType; 
   double timeStamp;
   SimJob * job;
   int count;
};

#endif
