#ifndef SCHEDULER_H
#define SCHEDULER_H

#include "heap.h"

class Scheduler {
 public:
    
    double utilization; 
    double qsize;
    int cur_qsize;
    Scheduler(int nproc);
    void handleArrival(Event *e);
    void handleJobDone(Event *e);
   
 private:
    
    char * free_proc_vector;
    int num_free_proc;
    SchedulingStrategy *strategy;
    Job *runq, *waitq;
    int nproc;
    double previousEventTime;

    void updateUtil();
    void callStrategy();
    void scheduleJob(SimJob *job);
};

#endif
