#include <stdio.h>                 
#include <stdlib.h>
#include "common.h"
#include "mysql.h"

class DbInterface{

 private:
    MYSQL mysql;
    int nproc;
    
    Job * fetch_jobs(int status);

 public:
    DbInterface();
    void set_nproc(int nproc);

    void connect(char *host, char *username, char *password);
    void connect(char *host, char *username, char *password, char *dbname);

    void insert_job(Job j);
    void update_pid(int id, int pid);
    void update_status(int id, int status);
    void update_bitmap(int id, char *bitmap);
    
    void close();

    Job * fetch_running_jobs();
    Job * fetch_queued_jobs();
    int get_max_port();

    void free_list(Job *);
};
