/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import projections.analysis.ParseTokenizer;

public class GenericSummaryReader {
    private static final int NUM_TAGS = 3;
    public static final int TOTAL_TIME = 0;
    public static final int NUM_MSGS = 1;
    public static final int MAX_TIME = 2;
    public int versionNum;
    public int myPE;
    public int numPE;
    public int numIntervals;
    public int numEPs;
    public double intervalSize;
    public int numPhases;
    public int[] processorUtil;
    public long[][] epData;
    public int numMarkedPairs;
    public long[][] markedPairs;
    public long[][][] phaseData;
    private double version;
    private BufferedReader reader;
    private ParseTokenizer tokenizer;
    private int tokenType;

    public GenericSummaryReader(String string, double d) throws IOException {
        try {
            this.reader = new BufferedReader(new FileReader(string));
            this.version = d;
            this.read();
            this.reader.close();
            this.reader = null;
        }
        catch (IOException iOException) {
            throw new IOException("Error reading file " + string + " : " + iOException.toString());
        }
    }

    public void read() throws IOException {
        int n;
        int n2;
        this.tokenizer = new ParseTokenizer(this.reader);
        this.tokenizer.parseNumbers();
        this.tokenizer.eolIsSignificant(true);
        this.tokenizer.whitespaceChars(47, 47);
        this.tokenizer.whitespaceChars(58, 58);
        this.tokenizer.whitespaceChars(91, 91);
        this.tokenizer.whitespaceChars(93, 93);
        this.tokenizer.wordChars(97, 122);
        this.tokenizer.wordChars(65, 90);
        this.tokenizer.checkNextString("ver");
        this.versionNum = (int)this.tokenizer.nextNumber("Version Number");
        this.myPE = (int)this.tokenizer.nextNumber("processor number");
        this.numPE = (int)this.tokenizer.nextNumber("number of processors");
        this.tokenizer.checkNextString("count");
        this.numIntervals = (int)this.tokenizer.nextNumber("count");
        this.tokenizer.checkNextString("ep");
        this.numEPs = (int)this.tokenizer.nextNumber("number of entry methods");
        this.tokenizer.checkNextString("interval");
        this.intervalSize = this.tokenizer.nextScientific("processor usage sample interval");
        if (this.versionNum > 2) {
            this.tokenizer.checkNextString("phases");
            this.numPhases = (int)this.tokenizer.nextNumber("phases");
        } else {
            this.numPhases = 1;
        }
        if (10 != this.tokenizer.nextToken()) {
            throw new IOException("extra garbage at end of line 1");
        }
        this.processorUtil = new int[this.numIntervals];
        this.epData = new long[this.numEPs][3];
        int n3 = 0;
        while ((this.tokenType = this.tokenizer.nextToken()) != 10 && n3 < this.numIntervals) {
            if (this.tokenType == -2) {
                n2 = (int)this.tokenizer.nval;
                this.processorUtil[n3++] = n2;
                this.tokenType = this.tokenizer.nextToken();
                if (this.tokenType == 43) {
                    this.tokenType = this.tokenizer.nextToken();
                    if (this.tokenType != -2) {
                        System.out.println("Unrecorgnized syntax at end of li\ne 2");
                    }
                    n = 1;
                    while (n < (int)this.tokenizer.nval) {
                        this.processorUtil[n3++] = n2;
                        ++n;
                    }
                    continue;
                }
                this.tokenizer.pushBack();
                continue;
            }
            System.out.println("extra garbage at end of line 2");
        }
        if (this.numIntervals != n3) {
            throw new IOException("numIntervals not agree!");
        }
        n2 = 0;
        this.tokenType = this.tokenizer.nextToken();
        if (-3 != this.tokenType) {
            this.tokenizer.pushBack();
        }
        while (-2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > n2) {
            this.epData[n2][0] = (int)this.tokenizer.nval;
            ++n2;
        }
        if (10 != this.tokenType) {
            throw new IOException("extra garbage at end of line 3");
        }
        this.tokenType = this.tokenizer.nextToken();
        if (-3 != this.tokenType) {
            this.tokenizer.pushBack();
        }
        n2 = 0;
        while (-2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > n2) {
            this.epData[n2][1] = (int)this.tokenizer.nval;
            ++n2;
        }
        if (10 != this.tokenType) {
            throw new IOException("extra garbage at end of line 4");
        }
        if ((double)this.versionNum > 3.0) {
            this.tokenType = this.tokenizer.nextToken();
            if (-3 != this.tokenType) {
                this.tokenizer.pushBack();
            }
            n2 = 0;
            while (-2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > n2) {
                this.epData[n2][2] = (int)this.tokenizer.nval;
                ++n2;
            }
            if (10 != this.tokenType) {
                throw new IOException("extra garbage at end of line 5");
            }
        }
        if (-3 != (this.tokenType = this.tokenizer.nextToken())) {
            this.tokenizer.pushBack();
        }
        n = (int)this.tokenizer.nextNumber("Number of Marked Events");
        int n4 = 0;
        while (n4 < n) {
            this.tokenizer.nextNumber("Number of Marked Events");
            this.tokenizer.nextNumber("Number of Marked Events");
            ++n4;
        }
        if (this.numPhases > 1) {
            this.phaseData = new long[this.numPhases][this.numEPs][3];
            int n5 = 0;
            while (n5 < this.numPhases) {
                n2 = 0;
                this.tokenizer.nextToken();
                this.tokenizer.nextToken();
                while (-2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > n2) {
                    this.phaseData[n5][n2][0] = (int)this.tokenizer.nval;
                    ++n2;
                }
                if (10 != this.tokenType) {
                    throw new IOException("extra stuff after (I) phase " + n5);
                }
                n2 = 0;
                this.tokenizer.nextToken();
                this.tokenizer.nextToken();
                while (-2 == (this.tokenType = this.tokenizer.nextToken()) && this.numEPs > n2) {
                    this.phaseData[n5][n2][1] = (int)this.tokenizer.nval;
                    ++n2;
                }
                if (10 != this.tokenType) {
                    throw new IOException("extra stuff after (II) phase " + n5);
                }
                ++n5;
            }
        }
        this.tokenizer = null;
    }
}

