/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import projections.gui.Analysis;
import projections.gui.AnimationWindow;
import projections.gui.OrderedIntList;

public class AnimationDisplayPanel
extends Panel
implements MouseMotionListener,
MouseListener {
    private float MAXHUE = 0.65f;
    private int numPs = -1;
    private int numIs = -1;
    private int pwidth;
    private int pheight;
    private int numrows;
    private int numcols;
    private int pold = -1;
    private int phoffset;
    private int pvoffset;
    private int hoffset;
    private int voffset;
    private float psize = 0.75f;
    private int curI = -1;
    private int curP = -1;
    private long Isize = 0L;
    private int[][] data;
    private Image offscreen;
    private Color[] colors;
    private int w;
    private int h;
    private AnimationWindow animationWindow;

    public AnimationDisplayPanel(AnimationWindow animationWindow) {
        this.animationWindow = animationWindow;
        this.setBackground(Analysis.background);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                AnimationDisplayPanel.this.w = AnimationDisplayPanel.this.getSize().width;
                AnimationDisplayPanel.this.h = AnimationDisplayPanel.this.getSize().height;
                if (AnimationDisplayPanel.this.w > 0 && AnimationDisplayPanel.this.h > 0) {
                    AnimationDisplayPanel.this.offscreen = AnimationDisplayPanel.this.createImage(AnimationDisplayPanel.this.w, AnimationDisplayPanel.this.h);
                    AnimationDisplayPanel.this.numcols = (int)Math.ceil(Math.sqrt((double)(AnimationDisplayPanel.this.w * AnimationDisplayPanel.this.numPs) / (double)AnimationDisplayPanel.this.h));
                    if (AnimationDisplayPanel.this.numcols > AnimationDisplayPanel.this.numPs) {
                        AnimationDisplayPanel.this.numcols = AnimationDisplayPanel.this.numPs;
                    }
                    AnimationDisplayPanel.this.numrows = (int)Math.ceil((double)AnimationDisplayPanel.this.numPs / (double)AnimationDisplayPanel.this.numcols);
                    AnimationDisplayPanel.this.pwidth = Math.min(AnimationDisplayPanel.this.w / AnimationDisplayPanel.this.numcols, AnimationDisplayPanel.this.h / AnimationDisplayPanel.this.numrows);
                    AnimationDisplayPanel.this.pheight = AnimationDisplayPanel.this.pwidth;
                    AnimationDisplayPanel.this.hoffset = (AnimationDisplayPanel.this.w - AnimationDisplayPanel.this.numcols * AnimationDisplayPanel.this.pwidth) / 2;
                    AnimationDisplayPanel.this.voffset = (AnimationDisplayPanel.this.h - AnimationDisplayPanel.this.numrows * AnimationDisplayPanel.this.pheight) / 2;
                    AnimationDisplayPanel.this.phoffset = (int)((1.0f - AnimationDisplayPanel.this.psize) * (float)AnimationDisplayPanel.this.pwidth) / 2;
                    AnimationDisplayPanel.this.pvoffset = (int)((1.0f - AnimationDisplayPanel.this.psize) * (float)AnimationDisplayPanel.this.pheight) / 2;
                    AnimationDisplayPanel.this.clearScreen();
                }
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.colors = new Color[101];
        int n = 0;
        while (n <= 100) {
            this.colors[n] = Color.getHSBColor((float)((double)(100 - n) / 100.0) * this.MAXHUE, 1.0f, 1.0f);
            ++n;
        }
        this.setParameters();
    }

    private void clearScreen() {
        if (this.offscreen == null) {
            return;
        }
        Graphics graphics = this.offscreen.getGraphics();
        if (graphics != null) {
            graphics.clearRect(0, 0, this.w, this.h);
        }
        this.repaint();
    }

    public int getCurI() {
        return this.curI;
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 400);
    }

    public void makeNextImage(Graphics graphics, int n) {
        int n2 = this.phoffset + this.hoffset;
        int n3 = this.pvoffset + this.voffset;
        int n4 = (int)((float)this.pwidth * this.psize);
        int n5 = (int)((float)this.pheight * this.psize);
        graphics.translate(n2, n3);
        int n6 = 0;
        int n7 = 0;
        while (n7 < this.numrows) {
            int n8 = 0;
            while (n8 < this.numcols) {
                int n9;
                if ((n9 = this.data[n6++][n]) >= 0 && n9 <= 100) {
                    graphics.setColor(this.colors[n9]);
                    graphics.fillRect(n8 * this.pwidth, n7 * this.pheight, n4, n5);
                }
                if (n6 >= this.numPs) break;
                ++n8;
            }
            ++n7;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.pold = -1;
        this.animationWindow.setStatusInfo(-1, -1, -1);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.pwidth <= 0 || this.pheight <= 0) {
            return;
        }
        int n = (mouseEvent.getY() - this.voffset) / this.pheight;
        int n2 = (mouseEvent.getX() - this.hoffset) / this.pwidth;
        this.curP = n * this.numcols + n2;
        if (this.curP >= this.numPs || this.curP < 0 || n < 0 || n2 < 0 || n >= this.numrows || n2 >= this.numcols) {
            this.curP = -1;
        }
        if (this.curP != this.pold) {
            this.pold = this.curP;
            if (this.curP >= 0 && this.curI != -1) {
                this.animationWindow.setStatusInfo(this.curP, this.curI, this.data[this.curP][this.curI]);
            } else {
                this.animationWindow.setStatusInfo(-1, -1, -1);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            return;
        }
        if (this.curI != -1) {
            this.makeNextImage(this.offscreen.getGraphics(), this.curI);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void setCurI(int n) {
        this.curI = n % this.numIs;
        if (this.curI < 0) {
            this.curI += this.numIs;
        }
        if (this.curP >= 0 && this.curP < this.numPs) {
            this.animationWindow.setStatusInfo(this.curP, this.curI, this.data[this.curP][this.curI]);
        }
        this.repaint();
    }

    public void setParameters() {
        OrderedIntList orderedIntList = this.animationWindow.validPEs;
        this.numPs = orderedIntList.size();
        this.Isize = this.animationWindow.intervalSize;
        this.data = Analysis.getAnimationData(this.Isize, this.animationWindow.startTime, this.animationWindow.endTime, orderedIntList);
        this.numIs = this.data[0].length;
        if (this.numIs > 0) {
            this.curI = 0;
        }
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        if (this.w > 0 && this.h > 0) {
            this.numcols = (int)Math.ceil(Math.sqrt((double)(this.w * this.numPs) / (double)this.h));
            if (this.numcols > this.numPs) {
                this.numcols = this.numPs;
            }
            this.numrows = (int)Math.ceil((double)this.numPs / (double)this.numcols);
            this.pheight = this.pwidth = Math.min(this.w / this.numcols, this.h / this.numrows);
            this.hoffset = (this.w - this.numcols * this.pwidth) / 2;
            this.voffset = (this.h - this.numrows * this.pheight) / 2;
            this.phoffset = (int)((1.0f - this.psize) * (float)this.pwidth) / 2;
            this.pvoffset = (int)((1.0f - this.psize) * (float)this.pheight) / 2;
            this.animationWindow.setTitleInfo(this.curI);
            this.clearScreen();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

