/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public abstract class MenuManager
implements ActionListener,
ItemListener {
    JMenuBar menubar;
    JFrame parent;

    public MenuManager(JFrame jFrame) {
        this.parent = jFrame;
        this.menubar = new JMenuBar();
        jFrame.setJMenuBar(this.menubar);
    }

    JMenu makeJMenu(Object object, Object[] objectArray) {
        JMenu jMenu = null;
        if (object instanceof JMenu) {
            jMenu = (JMenu)object;
        } else if (object instanceof String) {
            jMenu = new JMenu((String)object);
        } else {
            return null;
        }
        int n = 0;
        while (n < objectArray.length) {
            JMenuItem jMenuItem;
            if (objectArray[n] instanceof String) {
                jMenuItem = new JMenuItem((String)objectArray[n]);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            } else if (objectArray[n] instanceof JCheckBoxMenuItem) {
                jMenuItem = (JCheckBoxMenuItem)objectArray[n];
                jMenuItem.addItemListener(this);
                jMenu.add(jMenuItem);
            } else if (objectArray[n] instanceof JRadioButtonMenuItem) {
                jMenuItem = (JRadioButtonMenuItem)objectArray[n];
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            } else if (objectArray[n] instanceof JMenuItem) {
                jMenuItem = (JMenuItem)objectArray[n];
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            } else if (objectArray[n] == null) {
                jMenu.addSeparator();
            }
            ++n;
        }
        return jMenu;
    }

    void setEnabled(JMenu jMenu, boolean[] blArray) {
        if (blArray.length != jMenu.getItemCount()) {
            System.err.println("Projections Error: Menu items inconsistent!");
            System.exit(-1);
        } else {
            int n = 0;
            while (n < blArray.length) {
                JMenuItem jMenuItem = jMenu.getItem(n);
                if (jMenuItem instanceof JMenuItem) {
                    jMenuItem.setEnabled(blArray[n]);
                }
                ++n;
            }
        }
    }

    void setAllTo(JMenu jMenu, boolean bl) {
        int n = 0;
        while (n < jMenu.getItemCount()) {
            JMenuItem jMenuItem = jMenu.getItem(n);
            if (jMenuItem instanceof JMenuItem) {
                jMenuItem.setEnabled(bl);
            }
            ++n;
        }
    }

    abstract void stateChanged(int var1);

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }
}

