#include "dbinterface.h"

#define VERY_LARGE_BUF_SIZE 5 * LARGE_BUF_SIZE

DbInterface::DbInterface(){
    //mysql_init(&mysql);
}

void DbInterface::set_nodes(int nodes, int ppn){
    mysql_init(&mysql);
    this->num_nodes = nodes;
    this->ppn = ppn;
}

void DbInterface::connect(char *host, char *username, char *password){
    mysql_real_connect(&mysql, host, username, password, "faucets", 0, NULL, 0);
    //mysql_select_db(&mysql, "faucets");
}

void DbInterface::connect(char *host, char *username, 
                          char *password, char *dbname){
    mysql_real_connect(&mysql, host, username, password, dbname, 0, NULL, 0);
    //mysql_select_db(&mysql, dbname);
}

void DbInterface::close(){
    mysql_close(&mysql);
}

int DbInterface::insert_job(Job j){

    char query[VERY_LARGE_BUF_SIZE];

    snprintf(query, VERY_LARGE_BUF_SIZE, 
             "insert into jobInfo (name, type, minpe, maxpe, status, fd, argbuf, port, userName, stdout, stdin, stderr, pwd, allocatedTime, flags, email, display, ppn) values(\"%s\", %d, %d, %d, %d, %d, \"%s\", %d, \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", %d, %d, \"%s\", \"%s\", %d)", 
             j.name, j.type, j.min_nodes, j.max_nodes, j.status, 
             j.client_soc_fd, j.argbuf, j.port, j.userName, j.Stdout, 
             j.Stdin, j.Stderr, j.working_directory, j.allocated_time, 
             j.flags, j.email, j.display, j.ppn);
    
    MYSQL_RES *res;
    MYSQL_ROW row;

    if(mysql_query(&mysql, query) != 0){
	printf("Error executing query\n");
	return -1;
    }
    
    if ((res = mysql_store_result(&mysql)) != NULL)
	mysql_free_result(res);

    snprintf(query, VERY_LARGE_BUF_SIZE, "select max(id) from jobInfo");
    if(mysql_query(&mysql, query))
	return -1;
    
    if (!(res = mysql_store_result(&mysql)))
	return -1;

    if (!(row = mysql_fetch_row(res)))
	return -1;
    
    int dbid = atoi(row[0]);
    mysql_free_result(res);
    return dbid;
}

int DbInterface::get_max_port(){
    char query[VERY_LARGE_BUF_SIZE];
    
    snprintf(query, VERY_LARGE_BUF_SIZE, 
             "select max(port) from jobInfo where status=%d or status=%d",
	    RUNNING, QUEUED);

    if(mysql_query(&mysql, query))
	return -1;
    
    MYSQL_RES *res;
    MYSQL_ROW row;
    
    if (!(res = mysql_store_result(&mysql)))
	return -1;
    
    if (!(row = mysql_fetch_row(res))){
        mysql_free_result(res);
	return -1;
    }

    int port = 0;
    if(row[0] != NULL)
	port = atoi(row[0]);

    mysql_free_result(res);
    return port;    
}

int DbInterface::get_exitCode(int id){
    char query[VERY_LARGE_BUF_SIZE];
    
    snprintf(query, VERY_LARGE_BUF_SIZE, 
             "select exitCode from jobInfo where id = %d", id);

    if(mysql_query(&mysql, query))
	return -1;
    
    MYSQL_RES *res;
    MYSQL_ROW row;
    
    if (!(res = mysql_store_result(&mysql)))
	return -1;
    
    if (!(row = mysql_fetch_row(res))){
        mysql_free_result(res);
	return -1;
    }
    
    int code = 0;
    if(row[0] != NULL)
	code = atoi(row[0]);

    mysql_free_result(res);
    return code;    
}

void DbInterface::update_status(int id, int status){
    char query[VERY_LARGE_BUF_SIZE];
    snprintf(query, VERY_LARGE_BUF_SIZE, 
             "update jobInfo set status=%d where id=%d", status, id);
    mysql_query(&mysql, query);

    MYSQL_RES *res;
    
    if ((res = mysql_store_result(&mysql)) != NULL)
	mysql_free_result(res);
}

void DbInterface::update_exitCode(int id, int code){
    char query[VERY_LARGE_BUF_SIZE];
    snprintf(query, VERY_LARGE_BUF_SIZE, 
             "update jobInfo set exitCode=%d where id=%d", code, id);
    
    mysql_query(&mysql, query);

    MYSQL_RES *res;
    
    if ((res = mysql_store_result(&mysql)) != NULL)
	mysql_free_result(res);
}

void DbInterface::update_bitmap(int id, char *bitmap){
    char query[VERY_LARGE_BUF_SIZE];
    char sbitmap[SMALL_BUF_SIZE];
    int i;
    for(i = 0; i < num_nodes; i++)
	sbitmap[i] = bitmap[i] + '0';
    sbitmap[i] = 0;

    snprintf(query, VERY_LARGE_BUF_SIZE, 
             "update jobInfo set bitmap='%s' where id=%d", sbitmap, id);

    mysql_query(&mysql, query);

    MYSQL_RES *res;
    
    if ((res = mysql_store_result(&mysql)) != NULL)
	mysql_free_result(res);
}

void DbInterface::update_startTime(int id, int startTime){
    char query[VERY_LARGE_BUF_SIZE];
    snprintf(query, VERY_LARGE_BUF_SIZE, "update jobInfo set startTime=%d where id=%d", startTime, id);
    mysql_query(&mysql, query);

    MYSQL_RES *res;
    
    if ((res = mysql_store_result(&mysql)) != NULL)
	mysql_free_result(res);
}

void DbInterface::update_pid(int id, int pid){
    char query[VERY_LARGE_BUF_SIZE];
    snprintf(query, VERY_LARGE_BUF_SIZE, 
             "update jobInfo set pid=%d where id=%d", pid, id);

    MYSQL_RES *res;
    
    if ((res = mysql_store_result(&mysql)) != NULL)
	mysql_free_result(res);

    mysql_query(&mysql, query);
}

Job * DbInterface::fetch_jobs(int status){
    char query[VERY_LARGE_BUF_SIZE];
    snprintf(query, VERY_LARGE_BUF_SIZE, 
             "select * from jobInfo where status=%d order by id asc", status);

    //printf("before query = %s\n", query);
    if(mysql_query(&mysql, query))
	printf("Error executing query !!!!!\n");

    //printf("after query\n");

    MYSQL_RES *res;
    MYSQL_ROW row;
    if (!(res = mysql_store_result(&mysql)))
	return NULL;

    int njobs = mysql_num_rows(res);
    //printf("NJOBS = %d\n", njobs);

    if(njobs == 0){
        mysql_free_result(res);
	return NULL;
    }

    Job *jobq = new Job(num_nodes, ppn);
    
    Job *cur_job = jobq;
    while(njobs > 0){
        row = mysql_fetch_row(res);

	cur_job->dbid = atoi(row[0]);
	strncpy(cur_job->name, row[1], SMALL_BUF_SIZE-1);
	cur_job->name[SMALL_BUF_SIZE-1] = '\0';
	
	if(status >= RUNNING){
	    if(row[2] != NULL)
		cur_job->pid = atoi(row[2]);
	    else cur_job->pid = 0;

	    if(row[7] != NULL)
		for(int i = 0; i < num_nodes; i++){
		    cur_job->bit_map[i] = row[7][i] - '0';
		    if(cur_job->bit_map[i])
			cur_job->num_allocated_nodes++;
		}
	}

	cur_job->type = atoi(row[3]);
	cur_job->min_nodes = atoi(row[4]);
	cur_job->max_nodes = atoi(row[5]);
	
	cur_job->status = atoi(row[8]);	
	cur_job->client_soc_fd = atoi(row[9]);

	strncpy(cur_job->argbuf, row[10], LARGE_BUF_SIZE - 1);
	cur_job->argbuf[LARGE_BUF_SIZE - 1] = '\0';

	if(row[11] != NULL)
	    cur_job->port = atoi(row[11]);

	strncpy(cur_job->userName, row[12], SMALL_BUF_SIZE-1);
	cur_job->userName[SMALL_BUF_SIZE-1] = '\0';

	strncpy(cur_job->Stdout, row[13], SMALL_BUF_SIZE-1);
	cur_job->Stdout[SMALL_BUF_SIZE-1] = '\0';

	strncpy(cur_job->Stderr, row[14], SMALL_BUF_SIZE-1);
	cur_job->Stderr[SMALL_BUF_SIZE-1] = '\0';

	strncpy(cur_job->Stdin, row[15], SMALL_BUF_SIZE-1);
	cur_job->Stdin[SMALL_BUF_SIZE-1] = '\0';

	strncpy(cur_job->working_directory, row[16], SMALL_BUF_SIZE-1);
	cur_job->working_directory[SMALL_BUF_SIZE-1] = '\0';

	cur_job->allocated_time = atoi(row[17]);
	
	if(row[18] != NULL)
	    cur_job->start_time = atoi(row[18]);

        if(row[19] != NULL)
	    cur_job->flags = atoi(row[19]);
        
	if(row[20] != NULL)
	    strncpy(cur_job->email, row[20], SMALL_BUF_SIZE);

	if(row[21] != NULL)
	    strncpy(cur_job->display, row[21], SMALL_BUF_SIZE);

        if(row[23] != NULL)
	    cur_job->ppn = atoi(row[23]);

	njobs --;
	if(njobs > 0)
	    cur_job->next = new Job(num_nodes, ppn);

	cur_job = cur_job->next;
    }

    printf("Returning Job\n");

    mysql_free_result(res);
    return jobq;
}  

Job * DbInterface::fetch_running_jobs(){
    return fetch_jobs(RUNNING);
}

Job * DbInterface::fetch_queued_jobs(){
    return fetch_jobs(QUEUED);
}

void DbInterface::free_list(Job *jlist){
    Job *jptr = jlist;
    Job *prev = jptr;

    while(jptr != NULL){
	prev = jptr;
	jptr = jptr->next;
	delete prev;	
    }
}
