!******************************************************************************
!
! Purpose: store x-,y-,z-coordinates of grid nodes in binary format.
!
! Notes: only the finest grid is stored.
!
!
! Copyright: (c) 2001 by the University of Illinois
!
!******************************************************************************

SUBROUTINE WRITE_GRDB(iblock,ni,nj,nk,x,y,z,F_name)

  IMPLICIT NONE
  INTEGER :: iblock,ni,nj,nk
  DOUBLE PRECISION :: time,x(ni,nj,nk),y(ni,nj,nk),z(ni,nj,nk)
  INTEGER :: i,j,k
  CHARACTER (LEN=500) :: F_name,filnam
  INTEGER :: IF_GRID = 17

! open file; write time stamp

  IF (ABS(iblock) == 1) THEN
    WRITE(filnam,11) F_name(1:INDEX(F_name,' ')-1)
    OPEN (IF_GRID,file=filnam,form='unformatted',status='unknown')
    time = 0.0
    WRITE(IF_GRID) time
  ENDIF

! write block number and dimensions

  WRITE(IF_GRID) ABS(iblock),ni-1,nj-1,nk-1

! write coordinates

  WRITE(IF_GRID) &
    (((x(i,j,k), i=1,ni), j=1,nj), k=1,nk),&
    (((y(i,j,k), i=1,ni), j=1,nj), k=1,nk),&
    (((z(i,j,k), i=1,ni), j=1,nj), k=1,nk)

! close file

  IF (iblock < 0) THEN
    CLOSE(IF_GRID)
  ENDIF

11 FORMAT(a)
 
END SUBROUTINE

