#ifndef HEAP_H
#define HEAP_H

#include "SimJob.h"

class heapRecord
{ public:
  short deleted; // boolean
  Event *info;
};

class heapIterator{
public:
  int next;
};

class minHeap
{
private:
  heapRecord *h;
  int count;
  int size;
  void swap(int i, int j) 
    {
      heapRecord temp = h[i];
      h[i] = h[j];
      h[j] = temp;
    }
  
public:
  minHeap(int size);
  int numElements();
  int insert(Event *);
  Event *deleteMin();
  Event *iterator(heapIterator *);
  Event *next(heapIterator *);
};

class maxHeap
{
private:
  heapRecord *h;
  int count;
  int size;

  void swap(int i, int j) 
    {
      heapRecord temp = h[i];
      h[i] = h[j];
      h[j] = temp;
    }
  
public:  
  maxHeap(int size);
  int numElements();
  int insert(Event *);
  Event *deleteMax();
  Event *iterator(heapIterator *);
  Event *next(heapIterator *);
};

#endif
