#!/bin/sh

# Configuration: place to download glibc source code from
GLIBC_RELEASE_URL="http://ftp.gnu.org/gnu/glibc"
# GLIBC_RELEASE_URL="ftp://sourceware.cygnus.com/pub/glibc/releases"

if [ $# -ne 1 ]
then
	echo "Usage: build_pthreads.sh <version to build>"
	echo "Downloads, patches, builds, and installs a special"
	echo " version of glibc's libpthreads.a for Charm++."
	echo "This program will take about 2 hours, not counting the"
	echo "time to download 20+MB of source code from the glibc site,"
	echo "   $GLIBC_RELEASE_URL."
	exit 1
fi

ver=$1

# Grab the tar files from the web site and unpack:
wget $GLIBC_RELEASE_URL/glibc-$ver.tar.gz || exit 1
wget $GLIBC_RELEASE_URL/glibc-linuxthreads-$ver.tar.gz || exit 1

tar xzvf glibc-$ver.tar.gz
cd glibc-$ver
tar xzvf ../glibc-linuxthreads-$ver.tar.gz

# Patch source code to include Charm++ change to pthread_find_self(): 
# Uses the unified diff patch "pthread.patch" as:
cd linuxthreads
patch < ../../pthread.patch || exit 1
cd ..

# Configure and make:
./configure --enable-shared --enable-add-ons --host=i386-pc-linux || exit 1
make || exit 1
# The make will take something like 2 hours

# Copy the finished libpthread.a
echo "---------- Copying libpthread.a to Charm++ distrib directory --------"
cd linuxthreads
umask 2
cp libpthread.a libpthread-$ver.a
cp libpthread.so libpthread-$ver.so
cp libpthread-$ver.* /www/distrib/
cat libpthread-$ver.a | uuencode libpthread-$ver.a > /www/distrib/libpthread-$ver.uu

