/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

public class IntervalUtils {
    public static void fillIntervals(double[] dArray, double d, int n, double d2, double d3, double d4, boolean bl) {
        int n2 = (int)(d2 / d);
        int n3 = (int)(d3 / d);
        int n4 = n2 - n;
        int n5 = n3 - n;
        if (n4 >= dArray.length || n5 < 0) {
            return;
        }
        double d5 = (1.0 - (d2 - (double)n2 * d) / d) * 100.0;
        double d6 = (d3 - (double)n3 * d) / d * 100.0;
        if (n2 == n3) {
            if (n4 >= 0 && n5 < dArray.length) {
                int n6 = n4;
                dArray[n6] = dArray[n6] + d4;
                return;
            }
        } else {
            int n7 = n3 - n2 - 1;
            double d7 = d5 + d6 + (double)n7 * 100.0;
            double d8 = d5 / d7 * d4;
            double d9 = d6 / d7 * d4;
            double d10 = 100.0 / d7 * d4;
            if (n4 < 0) {
                int n8 = n4 = 0;
                dArray[n8] = dArray[n8] + d10;
            } else {
                int n9 = n4;
                dArray[n9] = dArray[n9] + d8;
            }
            if (n5 >= dArray.length) {
                int n10 = n5 = dArray.length - 1;
                dArray[n10] = dArray[n10] + d10;
            } else {
                int n11 = n5;
                dArray[n11] = dArray[n11] + d9;
            }
            int n12 = n4 + 1;
            while (n12 <= n5 - 1) {
                int n13 = n12++;
                dArray[n13] = dArray[n13] + d10;
            }
        }
    }

    public static double utilToTime(double d, double d2) {
        return d * d2 / 100.0;
    }

    public static double timeToUtil(double d, double d2) {
        return d / d2 * 100.0;
    }

    public static void utilToTime(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = dArray[n] * d / 100.0;
            ++n;
        }
    }

    public static void timeToUtil(double[] dArray, double d) {
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = dArray[n] / d * 100.0;
            ++n;
        }
    }

    public static double getBestIntervalSize(double d, int n) {
        double d2 = 1.0;
        double d3 = 10.0;
        double d4 = 1.0;
        int n2 = 0;
        while (true) {
            if (d > d2 && d <= d3) {
                d4 = d3;
                n2 = (int)Math.ceil(d * (double)n / d4);
                break;
            }
            d2 *= 10.0;
            d3 *= 10.0;
        }
        while (!(n2 > 10 && n2 <= 1000 || n2 <= 10 && d4 == 1.0)) {
            if (n2 <= 10) {
                n2 *= 10;
                d4 /= 10.0;
                continue;
            }
            n2 = (int)Math.ceil((double)n2 / 10.0);
            d4 *= 10.0;
        }
        return d4;
    }

    public static double[] rebin(double[] dArray, double d, int n) {
        double[] dArray2 = new double[n];
        double d2 = (double)dArray.length * d / (double)n;
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3;
            int n4 = (int)Math.floor((double)n2 * d / d2);
            if (n4 == (n3 = n2 == dArray.length - 1 ? n - 1 : (int)Math.floor((double)(n2 + 1) * d / d2))) {
                int n5 = n4;
                dArray2[n5] = dArray2[n5] + dArray[n2];
            } else {
                double d3 = ((double)(n4 + 1) * d2 - (double)n2 * d) / d;
                int n6 = n4;
                dArray2[n6] = dArray2[n6] + dArray[n2] * d3;
                double d4 = ((double)(n2 + 1) * d - (double)n3 * d2) / d;
                int n7 = n3;
                dArray2[n7] = dArray2[n7] + dArray[n2] * d4;
                double d5 = dArray[n2] * (1.0 - d3 - d4);
                double d6 = 0.0;
                if (n3 - n4 - 1 > 0) {
                    d6 = d5 / (double)(n3 - n4 - 1);
                }
                int n8 = n4 + 1;
                while (n8 < n3) {
                    int n9 = n8++;
                    dArray2[n9] = dArray2[n9] + d6;
                }
            }
            ++n2;
        }
        return dArray2;
    }

    public static double[] rebin(double[] dArray, double d, double d2) {
        int n = (int)Math.ceil((double)dArray.length * d / d2);
        return IntervalUtils.rebin(dArray, d, n);
    }

    public static void printArray(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            System.out.print(dArray[n] + " ");
            ++n;
        }
        System.out.println();
    }

    public static void main(String[] stringArray) {
        double[] dArray = new double[10];
        double d = 5.0;
        double d2 = 15.2;
        double d3 = 45.2;
        IntervalUtils.fillIntervals(dArray, d, 0, d2, d3, d3 - d2, false);
        IntervalUtils.printArray(dArray);
        dArray = new double[10];
        IntervalUtils.fillIntervals(dArray, d, 2, d2, d3, d3 - d2, false);
        IntervalUtils.printArray(dArray);
        dArray = new double[10];
        IntervalUtils.fillIntervals(dArray, d, 5, d2, d3, d3 - d2, false);
        IntervalUtils.printArray(dArray);
    }
}

