/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import javax.swing.ProgressMonitor;
import projections.analysis.AccumulatedSummaryReader;
import projections.analysis.ProjDefs;
import projections.analysis.StsReader;
import projections.gui.Analysis;
import projections.misc.SummaryFormatException;

public class SumAnalyzer
extends ProjDefs {
    public static final int NUM_MODES = 2;
    public static final int ACC_MODE = 0;
    public static final int NORMAL_MODE = 1;
    private int[][][][] dataArray;
    private StreamTokenizer tokenizer;
    private long[][] ChareTime;
    private int[][] NumEntryMsgs;
    private int[][] MaxEntryTime;
    private int PhaseCount;
    private long IntervalSize;
    private int IntervalCount;
    private long TotalTime;
    private long[][][] PhaseChareTime;
    private int[][][] PhaseNumEntryMsgs;
    private int[][] ProcessorUtilization;
    private int mode = 1;
    private AccumulatedSummaryReader accumulatedReader;

    public SumAnalyzer(StsReader stsReader, int n) {
        this.mode = n;
        this.accumulatedReader = new AccumulatedSummaryReader(stsReader.getSumAccumulatedName(), "5.0");
        this.TotalTime = (long)this.accumulatedReader.totalTime;
        this.IntervalCount = (int)this.accumulatedReader.numIntervals;
        this.IntervalSize = (long)this.accumulatedReader.intervalSize;
    }

    public SumAnalyzer() throws IOException, SummaryFormatException {
        int n;
        Reader reader;
        int n2 = 1;
        int n3 = 0;
        int n4 = 0;
        this.IntervalCount = 0;
        this.TotalTime = 0L;
        ProgressMonitor progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Determining max intervals", "", 0, n2);
        int n5 = 0;
        while (n5 < n2) {
            if (!progressMonitor.isCanceled()) {
                progressMonitor.setNote(n5 + " of " + n2);
                progressMonitor.setProgress(n5);
            } else {
                System.err.println("Fatal error - Projections cannot function without proper number of summary intervals!");
                System.exit(-1);
            }
            FileReader fileReader = new FileReader(Analysis.getSumName(n5));
            reader = new BufferedReader(fileReader);
            this.tokenizer = new StreamTokenizer(reader);
            this.tokenizer.parseNumbers();
            this.tokenizer.eolIsSignificant(true);
            this.tokenizer.whitespaceChars(47, 47);
            this.tokenizer.whitespaceChars(58, 58);
            this.tokenizer.whitespaceChars(91, 91);
            this.tokenizer.whitespaceChars(93, 93);
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.checkNextString("ver");
            n4 = (int)this.nextNumber("Version Number");
            int n6 = (int)this.nextNumber("processor number");
            n2 = (int)this.nextNumber("number of processors");
            this.checkNextString("count");
            n = (int)this.nextNumber("count");
            if (this.IntervalCount < n) {
                this.IntervalCount = n;
            }
            this.tokenizer = null;
            fileReader.close();
            ++n5;
        }
        progressMonitor.close();
        progressMonitor = new ProgressMonitor(Analysis.guiRoot, "Reading summary data", "", 0, n2);
        int n7 = 0;
        while (n7 < n2) {
            int n8;
            int n9;
            int n10;
            if (progressMonitor.isCanceled()) {
                progressMonitor.close();
                return;
            }
            progressMonitor.setNote(n7 + " of " + n2);
            progressMonitor.setProgress(n7);
            reader = new FileReader(Analysis.getSumName(n7));
            BufferedReader bufferedReader = new BufferedReader(reader);
            this.tokenizer = new StreamTokenizer(bufferedReader);
            this.tokenizer.parseNumbers();
            this.tokenizer.eolIsSignificant(true);
            this.tokenizer.whitespaceChars(47, 47);
            this.tokenizer.whitespaceChars(58, 58);
            this.tokenizer.whitespaceChars(91, 91);
            this.tokenizer.whitespaceChars(93, 93);
            this.tokenizer.wordChars(97, 122);
            this.tokenizer.wordChars(65, 90);
            this.checkNextString("ver");
            n4 = (int)this.nextNumber("Version Number");
            n = (int)this.nextNumber("processor number");
            n2 = (int)this.nextNumber("number of processors");
            this.checkNextString("count");
            int n11 = (int)this.nextNumber("count");
            this.checkNextString("ep");
            n3 = (int)this.nextNumber("number of entry methods");
            this.checkNextString("interval");
            double d = this.nextScientific("processor usage sample interval");
            this.IntervalSize = (long)Math.floor(d * 1000000.0);
            if (this.TotalTime < (long)n11 * this.IntervalSize) {
                this.TotalTime = (long)n11 * this.IntervalSize;
            }
            if (n4 > 2) {
                this.checkNextString("phases");
                this.PhaseCount = (int)this.nextNumber("phases");
            } else {
                this.PhaseCount = 1;
            }
            if (10 != this.tokenizer.nextToken()) {
                throw new SummaryFormatException("extra garbage at end of line 1");
            }
            if (n7 == 0) {
                this.ProcessorUtilization = new int[n2][];
                this.ChareTime = new long[n2][n3];
                this.NumEntryMsgs = new int[n2][n3];
                this.MaxEntryTime = new int[n2][n3];
            }
            this.ProcessorUtilization[n7] = new int[this.IntervalCount];
            int n12 = 0;
            boolean bl = false;
            while ((n10 = this.tokenizer.nextToken()) != 10 && n12 < n11) {
                if (n10 == -2) {
                    n9 = (int)this.tokenizer.nval;
                    this.ProcessorUtilization[n7][n12++] = n9;
                    n10 = this.tokenizer.nextToken();
                    if (n10 == 43) {
                        n10 = this.tokenizer.nextToken();
                        if (n10 != -2) {
                            System.out.println("Unrecorgnized syntax at end of line 2");
                        }
                        n8 = 1;
                        while (n8 < (int)this.tokenizer.nval) {
                            this.ProcessorUtilization[n7][n12++] = n9;
                            ++n8;
                        }
                        continue;
                    }
                    this.tokenizer.pushBack();
                    continue;
                }
                System.out.println("extra garbage at end of line 2");
            }
            if (n11 != n12) {
                System.out.println("numIntervals not agree" + this.IntervalCount + "v.s. " + n12 + "!");
            }
            int n13 = 0;
            n10 = this.tokenizer.nextToken();
            if (-3 != n10) {
                this.tokenizer.pushBack();
            }
            while (-2 == (n10 = this.tokenizer.nextToken()) && n3 > n13) {
                this.ChareTime[n7][n13] = (int)this.tokenizer.nval;
                ++n13;
            }
            if (10 != n10) {
                throw new SummaryFormatException("extra garbage at end of line 3");
            }
            n10 = this.tokenizer.nextToken();
            if (-3 != n10) {
                this.tokenizer.pushBack();
            }
            n13 = 0;
            while (-2 == (n10 = this.tokenizer.nextToken()) && n3 > n13) {
                this.NumEntryMsgs[n7][n13] = (int)this.tokenizer.nval;
                ++n13;
            }
            if (10 != n10) {
                throw new SummaryFormatException("extra garbage at end of line 4");
            }
            if ((double)n4 > 3.0) {
                n10 = this.tokenizer.nextToken();
                if (-3 != n10) {
                    this.tokenizer.pushBack();
                }
                n13 = 0;
                while (-2 == (n10 = this.tokenizer.nextToken()) && n3 > n13) {
                    this.MaxEntryTime[n7][n13] = (int)this.tokenizer.nval;
                    ++n13;
                }
                if (10 != n10) {
                    throw new SummaryFormatException("extra garbage at end of line 5");
                }
            }
            if (-3 != (n10 = this.tokenizer.nextToken())) {
                this.tokenizer.pushBack();
            }
            n9 = (int)this.nextNumber("Number of Marked Events");
            n8 = 0;
            while (n8 < n9) {
                this.nextNumber("Number of Marked Events");
                this.nextNumber("Number of Marked Events");
                ++n8;
            }
            if (this.PhaseCount > 1) {
                if (n7 == 0) {
                    this.PhaseChareTime = new long[this.PhaseCount][n2][n3];
                    this.PhaseNumEntryMsgs = new int[this.PhaseCount][n2][n3];
                }
                int n14 = 0;
                while (n14 < this.PhaseCount) {
                    n13 = 0;
                    this.tokenizer.nextToken();
                    this.tokenizer.nextToken();
                    while (-2 == (n10 = this.tokenizer.nextToken()) && n3 > n13) {
                        this.PhaseNumEntryMsgs[n14][n7][n13] = (int)this.tokenizer.nval;
                        ++n13;
                    }
                    if (10 != n10) {
                        throw new SummaryFormatException("extra garbage at end of line 3");
                    }
                    n13 = 0;
                    this.tokenizer.nextToken();
                    this.tokenizer.nextToken();
                    while (-2 == (n10 = this.tokenizer.nextToken()) && n3 > n13) {
                        this.PhaseChareTime[n14][n7][n13] = (int)this.tokenizer.nval;
                        ++n13;
                    }
                    if (10 != n10) {
                        throw new SummaryFormatException("extra garbage at end of line 4");
                    }
                    ++n14;
                }
            }
            this.tokenizer = null;
            ((InputStreamReader)reader).close();
            ++n7;
        }
        progressMonitor.close();
        Analysis.setTotalTime(this.TotalTime);
    }

    private void checkNextString(String string) throws IOException, SummaryFormatException {
        String string2 = this.nextString(string);
        if (!string.equals(string2)) {
            throw new SummaryFormatException("Expected " + string + " got " + string2);
        }
    }

    public long getIntervalSize() {
        return this.IntervalSize;
    }

    public long[][] GetChareTime() {
        return this.ChareTime;
    }

    public int[][] GetNumEntryMsgs() {
        return this.NumEntryMsgs;
    }

    public long[][] GetPhaseChareTime(int n) {
        return this.PhaseChareTime[n];
    }

    public int GetPhaseCount() {
        return this.PhaseCount;
    }

    public int[][] GetPhaseNumEntryMsgs(int n) {
        return this.PhaseNumEntryMsgs[n];
    }

    public int[][] GetSystemUsageData(int n, int n2, long l) throws IOException, SummaryFormatException {
        int n3 = n2 - n + 1;
        int n4 = this.ProcessorUtilization.length;
        int[][] nArray = new int[n4][n3];
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n7 < n3) {
                if (n6 < this.ProcessorUtilization[n5].length) {
                    n8 += this.ProcessorUtilization[n5][n6];
                }
                ++n9;
                ++n6;
                if ((long)(n10 = (int)((long)n10 + this.IntervalSize)) < l) continue;
                nArray[n5][n7++] = n8 / n9;
                n10 = 0;
                n8 = 0;
                n9 = 0;
            }
            ++n5;
        }
        return nArray;
    }

    public double[] getSummaryAverageData() {
        if (this.mode == 1) {
            int n;
            int n2 = this.ProcessorUtilization.length;
            double[] dArray = new double[this.IntervalCount];
            int n3 = 0;
            while (n3 < n2) {
                n = 0;
                while (n < this.IntervalCount) {
                    int n4 = n;
                    dArray[n4] = dArray[n4] + (double)this.ProcessorUtilization[n3][n];
                    ++n;
                }
                ++n3;
            }
            n = 0;
            while (n < this.IntervalCount) {
                int n5 = n++;
                dArray[n5] = dArray[n5] / ((double)n2 * 1.0);
            }
            return dArray;
        }
        if (this.mode == 0) {
            try {
                this.accumulatedReader.loadIntervalData(0L, this.IntervalCount - 1);
            }
            catch (IOException iOException) {
                System.err.println("Exception caught!");
                System.exit(-1);
            }
            double[] dArray = this.accumulatedReader.getUtilData();
            return dArray;
        }
        return null;
    }

    public long GetTotalTime() {
        return this.TotalTime;
    }

    private double nextNumber(String string) throws IOException, SummaryFormatException {
        if (-2 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read " + string);
        }
        return this.tokenizer.nval;
    }

    private double nextScientific(String string) throws IOException, SummaryFormatException {
        int n;
        double d = this.nextNumber(string + " mantissa");
        String string2 = this.nextString(string + " exponent");
        char c = string2.charAt(0);
        if (c != 'e' && c != 'd' && c != 'E' && c != 'D') {
            throw new SummaryFormatException("Couldn't find exponent in " + string2);
        }
        string2 = string2.substring(1);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SummaryFormatException("Couldn't parse exponent " + string2);
        }
        return d * Math.pow(10.0, n);
    }

    private String nextString(String string) throws IOException, SummaryFormatException {
        if (-3 != this.tokenizer.nextToken()) {
            throw new SummaryFormatException("Couldn't read string " + string);
        }
        return this.tokenizer.sval;
    }
}

