/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import projections.analysis.IntervalCapableReader;
import projections.analysis.IntervalUtils;
import projections.analysis.ParseTokenizer;
import projections.analysis.ProjectionsFormatException;
import projections.analysis.ProjectionsReader;

public class SummaryFileReader
extends ProjectionsReader
implements IntervalCapableReader {
    public int processor;
    public int numProcessors;
    public long numIntervals;
    public int numEntries;
    public double intervalSize;
    public double totalTime;
    public long numPhases;
    private double[] utilization;
    private long[] totalEPExecTime;
    private long[] timesEPcalled;
    private long[] maxEPExecTime;
    private long[][] phaseEPExecTime;
    private long[][] phaseEPNumMsgs;

    public SummaryFileReader(String string, String string2) {
        super(string, string2);
        try {
            this.readSpecializedData();
        }
        catch (ProjectionsFormatException projectionsFormatException) {
            System.err.println("Format Exception when reading from source [" + this.sourceString + "]");
            System.err.println(projectionsFormatException.toString());
            System.err.println("Data is now marked as unavailable.");
            this.markUnavailable();
        }
        catch (IOException iOException) {
            System.err.println("Unexpected IO error when reading from source [" + this.sourceString + "]");
            System.err.println("Data is now marked as unavailable.");
            this.markUnavailable();
        }
    }

    protected boolean checkAvailable() {
        File file = new File(this.sourceString);
        return file.canRead();
    }

    protected void readStaticData() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.sourceString));
        ParseTokenizer parseTokenizer = this.initNewTokenizer(bufferedReader);
        try {
            parseTokenizer.checkNextString("ver");
            double d = parseTokenizer.nextNumber("Version");
            if (d != Double.parseDouble(this.expectedVersion)) {
                throw new ProjectionsFormatException(this.expectedVersion, "Expected version does not match one read on file!");
            }
            this.processor = (int)parseTokenizer.nextNumber("Processor ID");
            this.numProcessors = (int)parseTokenizer.nextNumber("Total Number of Processors");
            parseTokenizer.checkNextString("count");
            this.numIntervals = (long)parseTokenizer.nextNumber("Number of Intervals");
            parseTokenizer.checkNextString("ep");
            this.numEntries = (int)parseTokenizer.nextNumber("Number of Entry Methods");
            parseTokenizer.checkNextString("interval");
            this.intervalSize = parseTokenizer.nextScientific("Interval Size") * 1000000.0;
            this.totalTime = (double)this.numIntervals * this.intervalSize;
            if (d > 2.0) {
                parseTokenizer.checkNextString("phases");
                this.numPhases = (long)parseTokenizer.nextNumber("Number of Phases");
            } else {
                this.numPhases = 1L;
            }
            if (!parseTokenizer.isEOL()) {
                throw new ProjectionsFormatException(this.expectedVersion, "Extra Stuff at the end of header line.");
            }
        }
        catch (IOException iOException) {
            throw new ProjectionsFormatException(this.expectedVersion, iOException.toString());
        }
        bufferedReader.close();
    }

    public void reset() throws IOException {
    }

    private ParseTokenizer initNewTokenizer(Reader reader) {
        ParseTokenizer parseTokenizer = new ParseTokenizer(reader);
        parseTokenizer.parseNumbers();
        parseTokenizer.eolIsSignificant(true);
        parseTokenizer.whitespaceChars(47, 47);
        parseTokenizer.whitespaceChars(58, 58);
        parseTokenizer.whitespaceChars(91, 91);
        parseTokenizer.whitespaceChars(93, 93);
        parseTokenizer.wordChars(97, 122);
        parseTokenizer.wordChars(65, 90);
        return parseTokenizer;
    }

    private void readSpecializedData() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.sourceString));
        ParseTokenizer parseTokenizer = this.initNewTokenizer(bufferedReader);
        bufferedReader.close();
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    public void loadIntervalData(long l, long l2) throws IOException {
        this.loadIntervalData(this.intervalSize, l, l2);
    }

    /*
     * Unable to fully structure code
     */
    public void loadIntervalData(double var1_1, long var3_2, long var5_3) throws IOException {
        block8: {
            var7_4 = new BufferedReader(new FileReader(this.sourceString));
            var8_5 = this.initNewTokenizer(var7_4);
            var9_6 = (int)(var5_3 - var3_2 + 1L);
            this.utilization = new double[var9_6];
            var8_5.skipLine();
            var10_7 = this.intervalSize;
            var12_8 = var1_1 * (double)var3_2;
            var14_9 = (double)var5_3 * var1_1;
            var16_10 = 0L;
            var18_11 = 4.9E-324;
            if (!(Double.parseDouble(this.expectedVersion) >= 3.0)) ** GOTO lbl34
            while (!var8_5.testEOL()) {
                if (var8_5.nextToken() == -2) {
                    var20_12 = var8_5.nval;
                    var22_14 = 1L;
                    if (var8_5.nextToken() == 43) {
                        if (var8_5.nextToken() != -2) {
                            throw new ProjectionsFormatException(this.expectedVersion, "Corrupt util data!");
                        }
                        var22_14 = (long)var8_5.nval;
                    } else {
                        var8_5.pushBack();
                    }
                    IntervalUtils.fillIntervals(this.utilization, var1_1, (int)var3_2, (double)var16_10 * var10_7, (double)(var16_10 + var22_14) * var10_7 - var18_11, (double)var22_14 * var10_7 * (var20_12 / 100.0), false);
                    var16_10 += var22_14;
                    if (!((double)var16_10 * var10_7 > var14_9)) continue;
                    break block8;
                }
                throw new ProjectionsFormatException(this.expectedVersion, "Corrupt util data!");
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                if ((double)(var16_10 + 1L) * var10_7 < var12_8) {
                    ++var16_10;
                    continue;
                }
                var20_13 = var8_5.nval;
                IntervalUtils.fillIntervals(this.utilization, var1_1, (int)var3_2, (double)var16_10 * var10_7, (double)(var16_10 + 1L) * var10_7 - var18_11, var10_7 * (var20_13 / 100.0), false);
                if ((double)(++var16_10) * var10_7 > var14_9) break;
lbl34:
                // 3 sources

                ** while (!var8_5.isEOL())
            }
lbl35:
            // 2 sources

            if (var8_5.isEOL()) {
                throw new ProjectionsFormatException(this.expectedVersion, "Unexpected EOL when reading utilization data!");
            }
        }
        var7_4.close();
        IntervalUtils.timeToUtil(this.utilization, var1_1);
    }

    public double[] getUtilData() {
        return this.utilization;
    }

    public void loadPhaseData(long l, long l2) throws IOException {
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        SummaryFileReader summaryFileReader = new SummaryFileReader(string, "4.0");
        System.out.println(summaryFileReader.getIntervalSize());
        System.out.println(summaryFileReader.processor);
        System.out.println(summaryFileReader.numProcessors);
        System.out.println(summaryFileReader.numIntervals);
        System.out.println(summaryFileReader.numEntries);
        System.out.println(summaryFileReader.intervalSize);
        System.out.println(summaryFileReader.totalTime);
        System.out.println(summaryFileReader.numPhases);
        long l = summaryFileReader.numIntervals - 17679L - 7L;
        try {
            summaryFileReader.loadIntervalData(l, l + 9L);
            double[] dArray = summaryFileReader.getUtilData();
            int n = 0;
            while (n < dArray.length) {
                System.out.print(dArray[n] + " ");
                ++n;
            }
            System.out.println();
            summaryFileReader.reset();
            summaryFileReader.loadIntervalData(summaryFileReader.getIntervalSize(), l, l + 9L);
            dArray = summaryFileReader.getUtilData();
            int n2 = 0;
            while (n2 < dArray.length) {
                System.out.print(dArray[n2] + " ");
                ++n2;
            }
            System.out.println();
            summaryFileReader.reset();
            summaryFileReader.loadIntervalData(0L, 10L);
            dArray = summaryFileReader.getUtilData();
            int n3 = 0;
            while (n3 < dArray.length) {
                System.out.print(dArray[n3] + " ");
                ++n3;
            }
            System.out.println();
            summaryFileReader.reset();
            summaryFileReader.loadIntervalData(summaryFileReader.numIntervals - 11L, summaryFileReader.numIntervals - 1L);
            dArray = summaryFileReader.getUtilData();
            int n4 = 0;
            while (n4 < dArray.length) {
                System.out.print(dArray[n4] + " ");
                ++n4;
            }
            System.out.println();
            summaryFileReader.reset();
            summaryFileReader.loadIntervalData(summaryFileReader.numIntervals - 11L, summaryFileReader.numIntervals + 5L);
            dArray = summaryFileReader.getUtilData();
            int n5 = 0;
            while (n5 < dArray.length) {
                System.out.print(dArray[n5] + " ");
                ++n5;
            }
            System.out.println();
            summaryFileReader.reset();
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
        }
    }
}

