/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import projections.analysis.IntervalData;
import projections.analysis.LogLoader;
import projections.analysis.LogReader;
import projections.analysis.StsReader;
import projections.analysis.SumAnalyzer;
import projections.analysis.SumDetailReader;
import projections.analysis.UsageCalc;
import projections.analysis.ViewerEvent;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.misc.EntryNotFoundException;
import projections.misc.LogLoadException;
import projections.misc.SummaryFormatException;

public class Analysis {
    public static final int NUM_FILETYPES = 3;
    public static final int FTYPE_SUMMARY = 0;
    public static final int FTYPE_SUMDETAIL = 1;
    public static final int FTYPE_LOG = 2;
    public static Color background = Color.black;
    public static Color foreground = Color.white;
    public static Component guiRoot;
    private static StsReader sts;
    private static LogLoader logLoader;
    private static SumAnalyzer sumAnalyzer;
    private static SumDetailReader[] summaryDetails;
    private static IntervalData intervalData;
    private static int[][][] systemUsageData;
    private static int[][][][] systemMsgsData;
    private static int[][][][] userEntryData;
    private static int[] bgData;
    private static long logReaderIntervalSize;
    private static long totalTime;
    private static Color[] entryColors;
    private static Color[] grayColors;
    private static Color[] userEventColors;
    private static Color[] grayUserEventColors;
    private static Color[] activeColorMap;
    private static Color[] activeUserColorMap;
    private static long jStartTime;
    private static long jEndTime;
    private static boolean jTimeAvailable;

    public static void initAnalysis(String string, Component component) throws IOException {
        guiRoot = component;
        try {
            sts = new StsReader(string);
            entryColors = Analysis.createColorMap(sts.getEntryCount());
            grayColors = Analysis.createGrayscaleColorMap(sts.getEntryCount());
            userEventColors = Analysis.createColorMap(sts.getNumUserDefinedEvents());
            grayUserEventColors = Analysis.createGrayscaleColorMap(sts.getNumUserDefinedEvents());
            activeColorMap = entryColors;
            activeUserColorMap = userEventColors;
        }
        catch (LogLoadException logLoadException) {
            throw new IOException(logLoadException.toString());
        }
        if (sts.hasSumAccumulatedFile()) {
            sumAnalyzer = null;
            sumAnalyzer = new SumAnalyzer(sts, 0);
            Analysis.setTotalTime(sumAnalyzer.GetTotalTime());
        }
        if (sts.hasSumFiles()) {
            try {
                sumAnalyzer = null;
                sumAnalyzer = new SumAnalyzer();
                Analysis.setTotalTime(sumAnalyzer.GetTotalTime());
            }
            catch (SummaryFormatException summaryFormatException) {
                System.err.println(summaryFormatException.toString());
            }
        }
        if (sts.hasSumDetailFiles() || sts.hasLogFiles()) {
            if (intervalData == null) {
                intervalData = new IntervalData();
            }
            Analysis.setTotalTime((long)((double)intervalData.getNumIntervals() * intervalData.getIntervalSize() * 1000000.0));
        }
        if (sts.hasLogFiles()) {
            logLoader = new LogLoader();
        }
    }

    public static Vector createTL(int n, long l, long l2, Vector vector, Vector vector2) {
        try {
            if (sts.hasLogFiles()) {
                if (logLoader == null) {
                    logLoader = new LogLoader();
                }
                return logLoader.createtimeline(n, l, l2, vector, vector2);
            }
            System.err.println("createTL: No log files available!");
            return null;
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LOG LOAD EXCEPTION");
            return null;
        }
    }

    public static int[][] getAnimationData(long l, long l2, long l3, OrderedIntList orderedIntList) {
        if (l >= l3 - l2) {
            l = l3 - l2;
        }
        int n = (int)(l2 / l);
        int n2 = (int)(l3 / l);
        int n3 = orderedIntList.size();
        Analysis.LoadGraphData(l, n, n2 - 1, false, null);
        int[][] nArray = new int[n3][n2 - n];
        int n4 = orderedIntList.nextElement();
        int n5 = 0;
        while (n4 != -1) {
            int n6 = 0;
            while (n6 < n2 - n) {
                nArray[n5][n6] = Analysis.getSystemUsageData(1)[n4][n6];
                ++n6;
            }
            n4 = orderedIntList.nextElement();
            ++n5;
        }
        return nArray;
    }

    public static String[][] getLogFileText(int n) {
        if (!sts.hasLogFiles()) {
            return null;
        }
        Vector vector = null;
        try {
            if (logLoader == null) {
                logLoader = new LogLoader();
            }
            vector = logLoader.view(n);
        }
        catch (LogLoadException logLoadException) {
            System.err.println("Failed to load Log files");
            return null;
        }
        if (vector == null) {
            return null;
        }
        int n2 = vector.size();
        if (n2 == 0) {
            return null;
        }
        String[][] stringArray = new String[n2][2];
        int n3 = 0;
        while (n3 < n2) {
            ViewerEvent viewerEvent = (ViewerEvent)vector.elementAt(n3);
            stringArray[n3][0] = "" + viewerEvent.Time;
            switch (viewerEvent.EventType) {
                case 1: {
                    stringArray[n3][1] = "CREATE message to be sent to " + viewerEvent.Dest;
                    break;
                }
                case 2: {
                    stringArray[n3][1] = "BEGIN PROCESSING of message sent to " + viewerEvent.Dest;
                    String[] stringArray2 = stringArray[n3];
                    stringArray2[1] = stringArray2[1] + " from processor " + viewerEvent.SrcPe;
                    break;
                }
                case 3: {
                    stringArray[n3][1] = "END PROCESSING of message sent to " + viewerEvent.Dest;
                    String[] stringArray3 = stringArray[n3];
                    stringArray3[1] = stringArray3[1] + " from processor " + viewerEvent.SrcPe;
                    break;
                }
                case 4: {
                    stringArray[n3][1] = "ENQUEUEING message received from processor " + viewerEvent.SrcPe + " destined for " + viewerEvent.Dest;
                    break;
                }
                case 14: {
                    stringArray[n3][1] = "IDLE begin";
                    break;
                }
                case 15: {
                    stringArray[n3][1] = "IDLE end";
                    break;
                }
                case 16: {
                    stringArray[n3][1] = "BEGIN PACKING a message to be sent";
                    break;
                }
                case 17: {
                    stringArray[n3][1] = "FINISHED PACKING a message to be sent";
                    break;
                }
                case 18: {
                    stringArray[n3][1] = "BEGIN UNPACKING a received message";
                    break;
                }
                case 19: {
                    stringArray[n3][1] = "FINISHED UNPACKING a received message";
                    break;
                }
                default: {
                    stringArray[n3][1] = "!!!! ADD EVENT TYPE " + viewerEvent.EventType + " !!!";
                }
            }
            ++n3;
        }
        return stringArray;
    }

    public static int getNumPhases() {
        if (sumAnalyzer != null) {
            return sumAnalyzer.GetPhaseCount();
        }
        return 0;
    }

    public static int[][] getSystemMsgsData(int n, int n2) {
        return systemMsgsData[n][n2];
    }

    public static int[][] getSystemUsageData(int n) {
        return systemUsageData[n];
    }

    public static long getTotalTime() {
        return totalTime;
    }

    public static void setTotalTime(long l) {
        totalTime = l;
    }

    public static long getLogReaderIntervalSize() {
        return logReaderIntervalSize;
    }

    public static double[] getSummaryAverageData() {
        return sumAnalyzer.getSummaryAverageData();
    }

    public static long getSummaryIntervalSize() {
        return sumAnalyzer.getIntervalSize();
    }

    public static Color getEntryColor(int n) {
        if (n < sts.getEntryCount()) {
            return activeColorMap[n];
        }
        return null;
    }

    public static void setEntryColor(int n, Color color) {
        if (n < sts.getEntryCount()) {
            Analysis.activeColorMap[n] = color;
        } else {
            System.err.println("Warning: entry point index " + n + " not found. Cannot set color");
        }
    }

    public static float[][] GetUsageData(int n, long l, long l2, OrderedIntList orderedIntList) {
        long[][] lArray;
        if (sts.hasLogFiles()) {
            UsageCalc usageCalc = new UsageCalc();
            return usageCalc.usage(n, l, l2, Analysis.getVersion());
        }
        int n2 = sts.getEntryCount();
        if (sumAnalyzer.GetPhaseCount() > 1) {
            orderedIntList.reset();
            lArray = sumAnalyzer.GetPhaseChareTime(orderedIntList.nextElement());
            if (orderedIntList.hasMoreElements()) {
                while (orderedIntList.hasMoreElements() && n > -1) {
                    long[][] lArray2 = sumAnalyzer.GetPhaseChareTime(orderedIntList.nextElement());
                    int n3 = 0;
                    while (n3 < n2) {
                        long[] lArray3 = lArray[n];
                        int n4 = n3;
                        lArray3[n4] = lArray3[n4] + lArray2[n][n3];
                        ++n3;
                    }
                }
            }
        } else {
            lArray = sumAnalyzer.GetChareTime();
        }
        float[][] fArray = new float[2][n2 + 4];
        double d = 100.0 / (double)Analysis.getTotalTime();
        int n5 = 0;
        while (n5 < n2) {
            fArray[0][n5] = (float)(d * (double)lArray[n][n5]);
            fArray[1][n5] = 0.0f;
            ++n5;
        }
        return fArray;
    }

    public static int[][] getUserEntryData(int n, int n2) {
        return userEntryData[n][n2];
    }

    public static boolean hasSystemMsgsData(int n, int n2) {
        if (systemMsgsData == null) {
            return false;
        }
        return null != systemMsgsData[n][n2];
    }

    public static boolean hasUserEntryData(int n, int n2) {
        if (userEntryData == null) {
            return false;
        }
        if (userEntryData[n][n2] == null) {
            return false;
        }
        int n3 = 0;
        while (n3 < Analysis.getNumProcessors()) {
            if (userEntryData[n][n2][n3] != null) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static int[] getBGData() {
        return bgData;
    }

    public static void LoadGraphData(long l, int n, int n2, boolean bl, OrderedIntList orderedIntList) {
        if (sts.hasLogFiles()) {
            LogReader logReader = new LogReader();
            logReader.read(l, n, n2, bl, orderedIntList);
            systemUsageData = logReader.getSystemUsageData();
            systemMsgsData = logReader.getSystemMsgs();
            userEntryData = logReader.getUserEntries();
            logReaderIntervalSize = logReader.getIntervalSize();
            logReader = null;
        } else if (sts.hasSumDetailFiles()) {
            if (sts.hasSumFiles()) {
                Analysis.loadSummaryData(l, n, n2);
            }
        } else if (sts.hasSumFiles()) {
            Analysis.loadSummaryData(l, n, n2);
        } else {
            System.err.println("Error: No data Files found!!");
        }
    }

    public static void loadSummaryData(long l, int n, int n2) {
        systemUsageData = new int[3][][];
        try {
            Analysis.systemUsageData[1] = null;
            Analysis.systemUsageData[1] = sumAnalyzer.GetSystemUsageData(n, n2, l);
        }
        catch (SummaryFormatException summaryFormatException) {
            System.err.println("Caught SummaryFormatException");
        }
        catch (IOException iOException) {
            System.err.println("Caught IOExcpetion");
        }
    }

    public static void loadSummaryData(int n, int n2) {
        Analysis.loadSummaryData(sumAnalyzer.getIntervalSize(), n, n2);
    }

    public static void loadSummaryData() {
        if (sts.hasSumFiles()) {
            long l = sumAnalyzer.getIntervalSize();
            int n = (int)(Analysis.getTotalTime() / l);
            Analysis.loadSummaryData(l, 0, n - 1);
        } else if (sts.hasSumAccumulatedFile()) {
            // empty if block
        }
    }

    public static double[][] getSumDetailData(int n, int n2) {
        return intervalData.getData(n, n2);
    }

    public static long searchTimeline(int n, int n2, int n3) throws EntryNotFoundException {
        try {
            if (sts.hasLogFiles()) {
                if (logLoader == null) {
                    logLoader = new LogLoader();
                }
                return logLoader.searchtimeline(n2, n3, n);
            }
            System.err.println("No log files!");
            return -1L;
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LogLoadException");
            return -1L;
        }
    }

    public static double getVersion() {
        if (sts == null) {
            return MainWindow.CUR_VERSION;
        }
        return sts.getVersion();
    }

    public static boolean hasSummaryData() {
        return sts.hasSumFiles() || sts.hasSumAccumulatedFile();
    }

    public static boolean hasLogData() {
        return sts.hasLogFiles();
    }

    public static boolean hasSumDetailData() {
        return sts.hasSumDetailFiles();
    }

    public static String getLogDirectory() {
        if (sts != null) {
            return sts.getLogPathname();
        }
        return null;
    }

    public static String getFilename() {
        return sts.getFilename();
    }

    public static String getLogName(int n) {
        return sts.getLogName(n);
    }

    public static String getSumName(int n) {
        return sts.getSumName(n);
    }

    public static String getSumDetailName(int n) {
        return sts.getSumDetailName(n);
    }

    public static int getNumProcessors() {
        return sts.getProcessorCount();
    }

    public static int getNumUserEntries() {
        return sts.getEntryCount();
    }

    public static String[][] getEntryNames() {
        return sts.getEntryNames();
    }

    public static String getEntryName(int n) {
        return sts.getEntryNames()[n][0];
    }

    public static String getEntryChareName(int n) {
        return sts.getEntryNames()[n][1];
    }

    public static int getNumUserDefinedEvents() {
        return sts.getNumUserDefinedEvents();
    }

    public static int getUserDefinedEventIndex(int n) {
        return sts.getUserEventIndex(n);
    }

    public static String getUserEventName(int n) {
        return sts.getUserEventName(n);
    }

    public static String[] getUserEventNames() {
        return sts.getUserEventNames();
    }

    public static int getNumIntervals() {
        if (intervalData == null) {
            System.err.println("No interval based data. Call to getNumIntervals is invalid.");
            return -1;
        }
        return intervalData.getNumIntervals();
    }

    public static double getIntervalSize() {
        if (intervalData == null) {
            System.err.println("No interval based data. Call to getIntervalSize is invalid.");
            return -1.0;
        }
        return intervalData.getIntervalSize();
    }

    public static Color getUserEventColor(int n) {
        if (sts != null) {
            return userEventColors[sts.getUserEventIndex(n)];
        }
        return null;
    }

    public static double[][] getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3) {
        return intervalData.getDataSummedAcrossProcessors(n, orderedIntList, n2, n3);
    }

    public static Vector getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3, OrderedIntList orderedIntList2) {
        return intervalData.getDataSummedAcrossProcessors(n, orderedIntList, n2, n3, orderedIntList2);
    }

    public static String getValidProcessorString() {
        if (sts.hasLogFiles()) {
            return sts.getValidProcessorString(0);
        }
        if (sts.hasSumFiles()) {
            return sts.getValidProcessorString(1);
        }
        if (sts.hasSumDetailFiles()) {
            return sts.getValidProcessorString(3);
        }
        return "";
    }

    public static OrderedIntList getValidProcessorList() {
        if (sts.hasLogFiles()) {
            return sts.getValidProcessorList(0);
        }
        if (sts.hasSumFiles()) {
            return sts.getValidProcessorList(1);
        }
        if (sts.hasSumDetailFiles()) {
            return sts.getValidProcessorList(3);
        }
        return null;
    }

    public static String getValidProcessorString(int n) {
        return sts.getValidProcessorString(n);
    }

    public static OrderedIntList getValidProcessorList(int n) {
        return sts.getValidProcessorList(n);
    }

    public static Color[] getColorMap() {
        return activeColorMap;
    }

    public static void setFullColor() {
        activeColorMap = entryColors;
        activeUserColorMap = userEventColors;
    }

    public static void setGrayscale() {
        activeColorMap = grayColors;
        activeUserColorMap = grayUserEventColors;
    }

    public static Color[] createGrayscaleColorMap(int n) {
        Color[] colorArray = new Color[n];
        float f = 1.0f;
        float f2 = 0.0f;
        float f3 = 0.9f;
        float f4 = (float)(0.8 / (double)n);
        int n2 = 0;
        while (n2 < n) {
            colorArray[n2] = Color.getHSBColor(f, f2, f3);
            if ((double)(f3 -= f4) < 0.1) {
                f3 = 0.1f;
            }
            ++n2;
        }
        return colorArray;
    }

    public static Color[] createColorMap(int n) {
        Color[] colorArray = new Color[n];
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = (float)(1.0 / (double)n);
        int n2 = 0;
        while (n2 < n) {
            colorArray[n2] = Color.getHSBColor(f, f2, f3);
            if ((double)(f -= f4) < 0.0) {
                f = 1.0f;
            }
            ++n2;
        }
        return colorArray;
    }

    public static Color[] createColorMap(int n, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        if (n2 > 0) {
            int n3 = 2;
            int n4 = 7;
            nArray2[n2 - 1] = 5;
            int n5 = n2 - 2;
            while (n5 >= 0) {
                nArray2[n5] = nArray2[n5 + 1] + n4;
                n4 += n3;
                --n5;
            }
        }
        return Analysis.createColorMap(n, nArray, nArray2);
    }

    public static Color[] createColorMap(int n, int[] nArray, int[] nArray2) {
        Color[] colorArray = new Color[n];
        int n2 = nArray.length;
        if (n2 == 0) {
            return Analysis.createColorMap(n);
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 += nArray2[n4];
            ++n4;
        }
        double d = (double)nArray2[n2 - 1] / (double)n3;
        int n5 = n - n2;
        double d2 = 1.0 / (d * (double)n5 + 1.0);
        if (d2 < 0.67) {
            d2 = 0.67;
        }
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        int n6 = 0;
        while (n6 < n2) {
            colorArray[nArray[n6]] = Color.getHSBColor((float)d3, (float)d4, (float)d5);
            d3 -= (double)nArray2[n6] / (double)n3 * d2;
            ++n6;
        }
        double d6 = d3 / (double)n5;
        int n7 = 0;
        while (n7 < n) {
            if (colorArray[n7] == null) {
                colorArray[n7] = Color.getHSBColor((float)d3, (float)d4, (float)d5);
                d3 -= d6;
            }
            ++n7;
        }
        return colorArray;
    }

    public static void setJTimeAvailable(boolean bl) {
        jTimeAvailable = bl;
    }

    public static boolean checkJTimeAvailable() {
        return jTimeAvailable;
    }

    public static void setJTime(long l, long l2) {
        jStartTime = l;
        jEndTime = l2;
    }

    public static long getJStart() {
        return jStartTime;
    }

    public static long getJEnd() {
        return jEndTime;
    }

    static {
        logReaderIntervalSize = -1L;
        totalTime = 0L;
    }
}

