/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import projections.gui.TimelineMessagePanel;
import projections.gui.TimelineObject;

public class TimelineMessageWindow
extends Frame
implements ActionListener {
    private TimelineObject obj;
    private TimelineMessagePanel canvas;
    private ScrollPane sp;

    public TimelineMessageWindow(TimelineObject timelineObject) {
        this.obj = timelineObject;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TimelineMessageWindow.this.Close();
            }
        });
        this.setBackground(Color.lightGray);
        this.setTitle("Timeline Entry Details");
        this.sp = new ScrollPane();
        this.canvas = new TimelineMessagePanel(timelineObject);
        this.sp.add(this.canvas);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        Button button = new Button("Close");
        button.addActionListener(this);
        panel.add(button);
        this.setLayout(new BorderLayout());
        this.add((Component)this.sp, "Center");
        this.add((Component)panel, "South");
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.Close();
    }

    private void Close() {
        this.setVisible(false);
        this.obj.CloseMessageWindow();
        this.dispose();
    }

    public Dimension getPreferredSize() {
        if (this.canvas != null) {
            Dimension dimension = this.canvas.getPreferredSize();
            dimension.width += 10;
            dimension.height += 30;
            return dimension;
        }
        return new Dimension(640, 480);
    }
}

