#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include "charm++.h"
#include "tcharmc.h"
#include "fem.h"
#include "mpi.h"

void myMakeFEM(void);
extern "C" void myParallelRoutine(void);

/* Start the program */
extern "C" void
TCHARM_User_setup(void)
{
	int nChunks=TCHARM_Get_num_chunks();
	TCHARM_Create(nChunks,myParallelRoutine);
	myMakeFEM();
	FEM_Attach(0);
	MPI_Attach("main");
}

/* Set up the FEM mesh */
void myMakeFEM(void)
{
  CkPrintf("myMakeFEM called\n");
  int dim=5;
  int np=4;
  int *conn=new int[dim*dim*np];

  int nelems=dim*dim, nnodes=(dim+1)*(dim+1);

  //Describe the nodes and elements
  FEM_Set_node(nnodes,0);
  FEM_Set_elem(0,nelems,0,np);

  //Create the connectivity array
  for(int y=0;y<dim;y++) for (int x=0;x<dim;x++) {
	   conn[(y*dim+x)*np+0]=(y  )*(dim+1)+(x  );
	   conn[(y*dim+x)*np+1]=(y+1)*(dim+1)+(x  );
	   conn[(y*dim+x)*np+2]=(y+1)*(dim+1)+(x+1);
	   conn[(y*dim+x)*np+3]=(y  )*(dim+1)+(x+1);
  }
  FEM_Set_elem_conn(0,conn);
  CkPrintf("Serial: %d nodes, %d elements\n",nnodes,nelems);
}

/* Run the computation */
extern "C" void myParallelRoutine(void)
{
  int i,j;
  int nnodes,nelems,nnodeData,nelemData,np;
  int ngnodes, ngelems; //Counts including ghosts

  FEM_Get_node(&nnodes,&nnodeData);

  FEM_Get_elem(0,&nelems,&nelemData,&np);
  int *conn=new int[np*nelems];
  FEM_Get_elem_conn(0,conn);
  int myId = FEM_My_partition();
  
  CkPrintf("Chunk %d: %d nodes, %d elements\n",myId,nnodes,nelems);

  int my[2],tot[2];
  my[0]=nnodes; my[1]=nelems;
  MPI_Reduce(&my,&tot,2,MPI_INT,MPI_SUM,0,MPI_COMM_WORLD);
  if (myId==0)
    CkPrintf("Total: %d nodes, %d elements\n",tot[0],tot[1]);
  
  
}
