#include <stdio.h>

#include "ckmulticast.h"

struct ArraySize2D {
	int sz[2];
};
PUPbytes(ArraySize2D);

#include "hello.decl.h"

/*readonly*/ CProxy_Main mainProxy;

void AxisMcastSetup(void);

/*mainchare*/
class Main : public Chare
{
  int nUnfinished;
public:
  Main(CkArgMsg* m)
  {
    //Process command-line arguments
    int x,y, nx=3, ny=2;
    if(m->argc >1 ) nx=atoi(m->argv[1]);
    if(m->argc >2 ) ny=atoi(m->argv[2]);
    delete m;

    //Start the computation
    CkPrintf("Running Hello on %d processors for (%d,%d) elements\n",
	     CkNumPes(),nx,ny);
    mainProxy = thishandle;

    AxisMcastSetup();
    ArraySize2D sz; sz.sz[0]=nx; sz.sz[1]=ny;
    CProxy_Hello arr = CProxy_Hello::ckNew();
    for (y=0;y<ny;y++) 
    for (x=0;x<nx;x++)
       arr(x,y).insert(sz);
     
    nUnfinished=ny; //Each row's reduction will call done
    arr.doContribute(0);
  };

  void done(void)
  {
    nUnfinished--;
    if (nUnfinished==0) {
      CkPrintf("All done\n");
      CkExit();
    }
  };
};


/********************** Library code ***********************/

/*readonly*/ CProxy_CkMulticastMgr AxisMcastMgr;
// Called from main, this routine prepares a multicast manager for AxisMcast:
void AxisMcastSetup(void) {
	AxisMcastMgr=CProxy_CkMulticastMgr::ckNew();
}

/*message*/
class AxisMcastMsg : public CkMcastBaseMsg, public CMessage_AxisMcastMsg
{
public:
	int axis; //Axis we're setting up (0==x, 1==y, ...)
	//ICK! CProxySection's can't be sent in messages, so we
	// can't just have proxy be a member.
	// Instead, we pup the proxy into here.  
	// FIXME: This buffer should be dynamically allocated,
	// since for a large enough section it will be too small.
	enum {dataMax=4096};
	char data[dataMax];
	
	AxisMcastMsg(int axis_, const CProxySection_AxisMcast2D &proxy) 
		:axis(axis_) 
	{
		PUP::toMem p(data);
		CProxySection_AxisMcast2D *cproxy=(CProxySection_AxisMcast2D *)&proxy;
		cproxy->pup(p);
		if (p.size()>dataMax) 
			CkAbort("Stupid fixed-length proxy buffer in AxisMcastMsg overflowed!");
	}
	
	void copyProxy(CProxySection_AxisMcast2D *destProxy) {
		PUP::fromMem p(data);
		destProxy->pup(p);
	}
};

#if 0
/// Map a CkMulticastMgr reduction client to a CkCallback:
void sectionCallbackClient(CkSectionCookie sid, void *param, int dataSize, void *data) 
{
	CkReductionMsg *msg=CkReductionMsg::buildNew(dataSize,data);
	CkCallback *cb=(CkCallback *)param;
	cb->send(msg);
	delete cb;
}
#endif

/*array [2D]*/
class AxisMcast2D : public CBase_AxisMcast2D {
    enum {N=2}; //Dimensionality--number of axes
    ArraySize2D sz;
    int nInitialized; //Number of dimensions we have cookies for
    CkSectionInfo axisCookies[N];
public:
    // You may want to broadcast along each axis, so here's
    // the section proxies for each axis this element belongs to.
    CProxySection_AxisMcast2D axisProxies[N];
 
 //Implementation routines:
    AxisMcast2D(ArraySize2D sz_) :sz(sz_) {
      nInitialized=0;
      AxisMcastCreate();
    }
    AxisMcast2D(CkMigrateMessage *m) {}
    void pup(PUP::er &p) {
      int axis;
      p|nInitialized;
      p|sz;
      for (axis=0;axis<N;axis++) p|axisCookies[axis];
      for (axis=0;axis<N;axis++) axisProxies[axis].pup(p);
    }
    ~AxisMcast2D() {}
    
    // Create the multicast groups for each axis:
    void AxisMcastCreate(void) {
      for (int axis=0;axis<N;axis++) {
        if (thisIndexMax.data()[axis]==0) 
	{ //I am the master of this axis:
	  //Make a list of everybody in my row
	  CkArrayIndexMax cur=thisIndexMax;
	  int nElems=sz.sz[axis]; 
          CkArrayIndexMax *elems=new CkArrayIndexMax[nElems];
	  for (int i=0;i<nElems;i++) {
	    cur.data()[axis]=i;
	    elems[i]=cur;
          }
	  //Make a section proxy for everybody in my row:
	  CProxySection_AxisMcast2D proxy = CProxySection_AxisMcast2D::
	    ckNew(thisArrayID, elems, nElems);
	  proxy.ckSectionDelegate(AxisMcastMgr.ckLocalBranch());
	  proxy.AxisMcast(new AxisMcastMsg(axis,proxy));
	  delete elems;
	}
      }
    }
    
    // Update the multicast groups.  Users might call this, e.g., after a migration.
    void AxisMcastUpdate(void) {
      for (int axis=0;axis<N;axis++)
        if (thisIndexMax.data()[axis]==0) 
	{ //I am the master of this axis: I do the cookie-updating broadcast
	  axisProxies[axis].AxisMcast(new AxisMcastMsg(axis,axisProxies[axis]));
	}
    }
    
    // Remotely called to update the axis cookie and proxy:
    void AxisMcast(AxisMcastMsg *m) {
      int axis=m->axis;
      CkGetSectionInfo(axisCookies[axis],m);
      m->copyProxy(&axisProxies[axis]);
      nInitialized++;
      delete m;
    }
 
 //User-callable routines:
    /// Return true if we are initialized.
    inline bool AxisInitialized(void) const {return nInitialized>=N;}
    
    /// Users call this to contribute to a reduction along this axis.
    void AxisContribute(int dataLen,const void *data, CkReduction::reducerType red,
    	const CkCallback &cb, int axis) 
    {
      if (thisIndexMax.data()[axis]==0) { //I am the master of this row: I'm responsible for the callback
        CkCallback *param=new CkCallback(cb); //Make a heap copy of the destination
//        AxisMcastMgr.ckLocalBranch()->setReductionClient(axisProxies[axis],sectionCallbackClient,param);
        AxisMcastMgr.ckLocalBranch()->setReductionClient(axisProxies[axis],param);
      }
      AxisMcastMgr.ckLocalBranch()->contribute(dataLen,(void *)data,red,axisCookies[axis]);
    }
};

/*************************** User Code ************************/

/*array [2D]*/
class Hello : public AxisMcast2D 
{
public:
  Hello(ArraySize2D &sz) :AxisMcast2D(sz)
  {
    CkPrintf("Hello (%d,%d) created on %d\n",thisIndex.x,thisIndex.y,CkMyPe());
  }

  Hello(CkMigrateMessage *m) :AxisMcast2D(m) {}
  
  void doContribute(int axis)
  {
    CProxy_Hello myProxy(thisArrayID);
    CProxyElement_Hello myElement=myProxy(thisIndex.x,thisIndex.y);
    if (!AxisInitialized()) { //Busy-wait until Axis is ready.
      myElement.doContribute(axis); return;
    }
    CkPrintf("doContribute(%d) on element (%d,%d)\n",axis,thisIndex.x,thisIndex.y);
    int val=0;
    if (thisIndex.x==0) val=thisIndex.y;
    AxisContribute(sizeof(int),&val,CkReduction::sum_int,
    	CkCallback(CkIndex_Hello::doPrint(0),myElement),axis);
  }
  void doPrint(CkReductionMsg *msg) {
    int val=*(int *)msg->getData();
    CkPrintf("DoPrint (%d,%d) on PE %d: %d\n",thisIndex.x,thisIndex.y,CkMyPe(),val);
    delete msg;
    mainProxy.done();
  }
  
};

#include "hello.def.h"
