recursive subroutine MPI_Main
  implicit none
  include 'mpif.h'

  integer :: thisIndex, ierr, nblocks, i
  double precision, allocatable, dimension(:) :: inbuf, outbuf

  call MPI_Init(ierr)
  call MPI_Comm_rank(MPI_COMM_WORLD, thisIndex, ierr)
  call MPI_Comm_size(MPI_COMM_WORLD, nblocks, ierr)

  allocate(inbuf(0:nblocks-1))
  allocate(outbuf(0:nblocks-1))

  do i = 0, nblocks-1
    inbuf(i) = i
    outbuf(i) = -1
  enddo

  call MPI_Alltoall(inbuf, 1, MPI_DOUBLE_PRECISION, outbuf, 1, &
&                    MPI_DOUBLE_PRECISION, MPI_COMM_WORLD, ierr)

  ierr = 0
  do i = 0, nblocks-1
    if (outbuf(i) .ne. thisIndex) then
      call MPI_Print('Message corrupted',17)
      ierr = 1
    end if
  enddo
  if (ierr .eq. 0) then
    call MPI_Print('alltoall test passed',20)
  end if
  call MPI_Finalize(ierr)

end subroutine
