#include <stdio.h>
#include "ccs-client.c"

int main(int argc,char **argv) {
	/* Connect to the CCS server */
	CcsServer svr;
	if (argc!=3) { 
		printf("Usage: client <host> <port>\n");
		exit(1);
	}
	const char *host=argv[1];
	int port=atoi(argv[2]);
	CcsConnect(&svr, host, port, NULL);
	
	/* Send an echo request to the server */
	CcsSendRequest(&svr,"testEcho",0, 1,"r");
	char reply; int replyLen=1;
	CcsRecvResponse(&svr,1,&reply,60);
	if (reply=='r') printf("Client> It worked!\n");
	else printf("Client> Got back wrong answer '%c'\n",reply);
	
	/* Exit the server program */
	CcsSendRequest(&svr,"pleaseExit",0,0,0);
	CcsFinalize(&svr);
	return 0;
}
