#include "charm++.h"
#include "pgm.decl.h"
#include "tempo.h"

#define NITER 50000

extern CkChareID mainhandle;

class UserArray : public TempoArray
{
    int sz;
  public:
    UserArray(void);
    UserArray(CkMigrateMessage *msg);
    void startMigrate(void);
    void pup(PUP::er &p);
};

extern int migHandle;

class MigrateInfo : public CMessage_MigrateInfo {
  public:
    ArrayElement *elem;
    int where;
    MigrateInfo(ArrayElement *e, int w) : elem(e), where(w) {}
};

class migrator : public Group {
  public:
    migrator(void) { migHandle = thisgroup; }
    void migrateElement(MigrateInfo *msg) {
      // CkPrintf("migrator: tid is %p\n", CthSelf());
      msg->elem->migrateMe(msg->where);
      delete msg;
    }
};

class main : public Chare
{
  double starttime, endtime;
  public :
    main(CkArgMsg *);
    void Finish(void);
};
