/**************************************************
 *
 * This is a example to show how to export a Charm++ library to Ampi
 * compatiable code.  The charm++ library code includes: dumblib.ci,
 * dumblib.h, dumblib.C. And the code that does the export are
 * ampi-dumblib.h and ampi-dumblib.C. The demo.C demostrates how to use
 * the exported code in Ampi.

 * The most tricky part of exporting is the initialization
 * function. Please see init-lib() in ampi-dumblib.C.
**************************************************/


#include "ampi-dumblib.h"

/***************************************************
 * init routine of the library: 
 *   called on every node that uses library call
 *  
 * Input: 
 *   myComm -- user specified set of commicator
 *   (a shadow array of myComm array (myarray) will 
 *    be created)      
 ***************************************************/

void init_dumblib(MPI_Comm myComm){

  int myRank, myWorldRank;
  CkArrayID myArrayID;

  MPI_Comm_rank(myComm, &myRank);
  MPI_Comm_rank(MPI_COMM_WORLD, &myWorldRank);

  if (myRank == 0){
    
    CkArrayOptions opts;
    opts.bindTo(TCharm::get()->getProxy());//array binds to TCharm array 

    myarray = CProxy_UserArray::ckNew(opts);
    myArrayID = myarray.ckGetArrayID();
  }
  


  if (myRank>=0) {

    int ierr;
    // arrayID is broadcasted to every node in myComm
    ierr = MPI_Bcast((void *)&myArrayID, sizeof(CkArrayID), MPI_INT, 0, myComm);
    CProxy_UserArray myArray1(myArrayID);
    myarray = myArray1;

    MPI_Comm_rank(MPI_COMM_WORLD, &myWorldRank);
    myarray(myWorldRank).insert();          //array element is locally inserted
  }

  MPI_Barrier(myComm);
}

/**************************************************
 * some library routine that does your stuff
 *
 **************************************************/

void start_doStuff() {
  
  int i;

  MPI_Comm_rank(MPI_COMM_WORLD, &i);
  UserArray *arrayLocal = myarray(i).ckLocal();
  CkAssert(arrayLocal!=NULL);

  arrayLocal->doStuff();

}

	
