#include <ampi.h>
#include <charm++.h>

int 
main(int argc, char** argv)
{
  int i, size, worldsize, rank, worldrank, color;
  int *winArea, *rcvvals;
  MPI_Win win;

  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &worldsize);
  MPI_Comm_rank(MPI_COMM_WORLD, &worldrank);
  MPI_Comm comm;
  color = (worldrank<worldsize/2)?0:1;
  //color = worldrank % 2;
  MPI_Comm_split(MPI_COMM_WORLD, color, 0, &comm);
  
  if(color == 0){
    MPI_Comm_size(comm, &size);
    MPI_Comm_rank(comm, &rank);
    MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &winArea);
    MPI_Alloc_mem(sizeof(int), MPI_INFO_NULL, &rcvvals);
    MPI_Win_create((void*)winArea, sizeof(int), sizeof(int), 0,
		   comm, &win);
    *winArea = worldrank;
    MPI_Win_fence(0, win);

    if(rank == 0){
      *rcvvals = -1;
      MPI_Get(&rcvvals[0], 1, MPI_INT, 1, 0, 1, MPI_INT, win);
    }
    
    MPI_Win_fence(0, win);

    if(rank == 0){
      CkPrintf("Rank [%d:%d] get rcvvals[%d]=%d \n",
	       rank, worldrank, 0, rcvvals[0]);
    }

    MPI_Win_free(&win);  
    MPI_Free_mem(winArea);
    MPI_Free_mem(rcvvals);
    
  }
  MPI_Finalize();
  return(0);
}

