/*****************************************************************************
 * $Source: /cvsroot/charm-5.8/src/ck-ldb/LBObj.C,v $
 * $Author: gzheng $
 * $Date: 2002/11/01 04:32:42 $
 * $Revision: 1.9 $
 *****************************************************************************/

/**
 * \addtogroup CkLdb
*/
/*@{*/

#include <converse.h>

#if CMK_LBDB_ON

#include "LBObj.h"
#include "LBOM.h"
#include "LBDBManager.h"

/*************************************************************
 * LBObj Object-data Code
 *************************************************************/

void LBObj::Clear(void)
{
//  data.handle = myhandle;
//  data.id = myid;
//  data.omHandle = parentOM;
//  data.omID = parentDB->LbOM(parentOM)->id();
  data.cpuTime = 0.;
  data.wallTime = 0.;
}

void LBObj::IncrementTime(double walltime, double cputime)
{
  parentDB->MeasuredObjTime(walltime,cputime);
  data.wallTime += walltime;
  data.cpuTime += cputime;
}

void LBObj::StartTimer(void)
{
  startWTime = CmiWallTimer();
  startCTime = CmiCpuTimer();
}

void LBObj::StopTimer(double* walltime, double* cputime)
{
  *walltime = CmiWallTimer() - startWTime;
  *cputime = CmiCpuTimer() - startCTime;
}

#endif

/*@}*/
