/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import projections.analysis.AsciiIntegerReader;
import projections.analysis.PointCapableReader;
import projections.analysis.ProjectionsReader;
import projections.gui.Analysis;
import projections.misc.LogEntryData;

public class GenericLogReader
extends ProjectionsReader
implements PointCapableReader {
    private static final long INITIAL_STEP = 1024L;
    private AsciiIntegerReader reader;
    private double version;
    private Vector[] intervalData;

    public GenericLogReader(String string, double d) {
        super(string, String.valueOf(d));
        try {
            this.reader = new AsciiIntegerReader(new FileReader(string));
            this.version = d;
            this.reader.nextLine();
        }
        catch (IOException iOException) {
            System.err.println("Error reading file " + string);
        }
    }

    public GenericLogReader(int n, double d) {
        super(Analysis.getLogName(n), String.valueOf(d));
        try {
            this.reader = new AsciiIntegerReader(new FileReader(this.sourceString));
            this.version = d;
            this.reader.nextLine();
        }
        catch (IOException iOException) {
            System.err.println("Error reading file " + this.sourceString);
        }
    }

    protected boolean checkAvailable() {
        File file = new File(this.sourceString);
        return file.canRead();
    }

    public void readStaticData() {
    }

    public void reset() throws IOException {
        this.reader.close();
        this.reader = new AsciiIntegerReader(new FileReader(this.sourceString));
        this.reader.nextLine();
    }

    public void nextEvent(LogEntryData logEntryData) throws IOException, EOFException {
        logEntryData.type = this.reader.nextInt();
        switch (logEntryData.type) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                logEntryData.time = this.reader.nextLong();
                logEntryData.pe = this.reader.nextInt();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: {
                logEntryData.mtype = this.reader.nextInt();
                logEntryData.entry = this.reader.nextInt();
                logEntryData.time = this.reader.nextLong();
                logEntryData.event = this.reader.nextInt();
                logEntryData.pe = this.reader.nextInt();
                logEntryData.msglen = this.version > 1.0 ? this.reader.nextInt() : -1;
                if (!(Analysis.getVersion() >= 5.0) || logEntryData.type != 1) break;
                logEntryData.sendTime = this.reader.nextLong();
                break;
            }
            case 4: 
            case 5: {
                logEntryData.mtype = this.reader.nextInt();
                logEntryData.time = this.reader.nextLong();
                logEntryData.event = this.reader.nextInt();
                logEntryData.pe = this.reader.nextInt();
                break;
            }
            case 8: 
            case 9: {
                logEntryData.time = this.reader.nextLong();
                logEntryData.event = this.reader.nextInt();
                logEntryData.pe = this.reader.nextInt();
                break;
            }
            case 6: 
            case 7: {
                logEntryData.time = this.reader.nextLong();
                break;
            }
            case 100: {
                logEntryData.userEventID = this.reader.nextInt();
                logEntryData.time = this.reader.nextLong();
                logEntryData.event = this.reader.nextInt();
                logEntryData.pe = this.reader.nextInt();
                break;
            }
            default: {
                logEntryData.type = -1;
                this.reader.nextLine();
            }
        }
    }

    public void nextEventOnOrAfter(long l, LogEntryData logEntryData) throws IOException, EOFException {
        this.seqLookForNextEventOnOrAfter(l, logEntryData);
    }

    private void lookForNextEventOnOrAfter(long l, long l2, long l3, long l4, LogEntryData logEntryData) throws IOException, EOFException {
        this.reader.skip(l2 - l4);
        this.reader.nextLine();
        this.nextEvent(logEntryData);
        while (logEntryData.type == -1) {
            this.nextEvent(logEntryData);
        }
        if (logEntryData.time >= l && logEntryData.time <= l) {
            return;
        }
    }

    private void seqLookForNextEventOnOrAfter(long l, LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEvent(logEntryData);
            while (logEntryData.type == -1) {
                this.nextEvent(logEntryData);
            }
        } while (logEntryData.time < l);
    }

    public void nextEventOfType(int n, LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEvent(logEntryData);
        } while (logEntryData.type != n);
    }

    public void nextEventOfTypeOnOrAfter(int n, long l, LogEntryData logEntryData) throws IOException, EOFException {
        do {
            this.nextEventOnOrAfter(l, logEntryData);
        } while (logEntryData.type != n);
    }
}

