/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import projections.gui.ProfileData;

public class ProfileDisplayCanvas
extends Container {
    private ProfileData data;
    private Image offscreen;

    public ProfileDisplayCanvas(ProfileData profileData) {
        this.data = profileData;
        this.offscreen = null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 400);
    }

    public void makeNewImage() {
        if (this.data.plist == null) {
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (n > 0 && n2 > 0) {
            try {
                this.offscreen = this.createImage(n, n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.out.println("NOT ENOUGH MEMORY!");
                return;
            }
            if (this.offscreen == null) {
                return;
            }
            Graphics graphics = this.offscreen.getGraphics();
            graphics.setClip(0, 0, n, n2);
            super.paint(graphics);
            graphics.dispose();
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        if (this.offscreen != null) {
            int n = this.data.profileWindow.getHSBValue();
            int n2 = this.data.profileWindow.getVSBValue();
            graphics.drawImage(this.offscreen, n, n2, n + this.data.vpw, n2 + this.data.vph, n, n2, n + this.data.vpw, n2 + this.data.vph, null);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void updateColors() {
        if (this.offscreen != null) {
            Graphics graphics = this.offscreen.getGraphics();
            super.paint(graphics);
            graphics.dispose();
            this.repaint();
        }
    }
}

