#include "ccs-client.h"
#include "ccs-client.c"
#include "converse.h"
#include <stdio.h>
#include <stdlib.h>

static void  usage(void)
{
  fprintf(stderr, "Usage: client svrIP svrPort\n");
  exit(1);
}
CcsServer svr;
char *buf;

/*Return the total time to receive a CCS request of this size:*/
double rtt(int size,int *retSize) {
    double startTime=CmiWallTimer();
    char sizeBuf[20];
    sprintf(sizeBuf,"%d",size);
    CcsSendRequest(&svr, "rttTest", 0, strlen(sizeBuf)+1,
	(char *)sizeBuf);
    size=CcsRecvResponse(&svr, size, buf,60);
    if (retSize!=NULL) *retSize=size;
    return CmiWallTimer()-startTime;
}
int shortMessageTest=0;

void user_main(int argc, char **argv)
{
  char *host=argv[1];
  int port,i;
  int maxSize=10*1024*1024;
  int size;
  if(argc < 3) {
    usage();
  }
  port=atoi(argv[2]);
  buf=malloc(maxSize);
  
  CcsConnect(&svr, host,port, NULL);
  
  if (shortMessageTest)
    while (1) {
  	printf("WOW! This is slow!\n");
  	rtt(10,NULL);
    }
  
  //First, estimate short-message ping time:
  printf("10-byte ping: %.3f ms\n",rtt(10,NULL)*1.0e3);
  printf("1-meg ping: %.3f ms\n",rtt(1*1024*1024,NULL)*1.0e3);
  
  //Now, smoothly vary the message size:
  size=10;
  i=0;
  while (size<maxSize) {
    int retSize=size;
    double rttTime=rtt(size,&retSize);
    printf("RTT %d  %d  %.6f  %.2f MB/sec\n",i,retSize,rttTime,(retSize*1.0e-6)/rttTime);
    size=(int)(size*1.1);
    i++;
  }
}

main(int argc, char **argv)
{
  ConverseInit(argc, argv, user_main,1, 0);
}

