#include <stdio.h>
#include "ccs-client.c"

int main(int argc,char **argv) {
	/* Connect to the CCS server */
	CcsServer svr;
	if (argc!=3) { 
		printf("Usage: client <host> <port>\n");
		exit(1);
	}
	const char *host=argv[1];
	int port=atoi(argv[2]);
	CcsConnect(&svr, host, port, NULL);
	
	/* Send an echo request to the server */
	char reply[1000]; int replyLen=1000;
	for (int i=0;i<3;i++) {
	  CcsSendRequest(&svr,"perf_monitor",0, 1,"r");
	  CcsRecvResponse(&svr,replyLen,reply,60);
	  printf("Got back: %s\n",reply);
	}
	
	/* Exit the server program */
	CcsSendRequest(&svr,"pleaseExit",0,0,0);
	CcsFinalize(&svr);
	return 0;
}
