/*
Create a single, extremely simple block-- a regular,
axis-aligned box.

Orion Sky Lawlor, olawlor@acm.org, 7/18/2001
*/
#include <stdio.h>
#include "adj.h"
#include "util.h"
#include "makeflo.h"

void printUsage(const char *why)
{
	printf("Usage: simpleblock <output .msh or .hdf file>\n"
	  "     <X start> <X end> <X steps> \n"
	  "     <Y start> <Y end> <Y steps> \n"
	  "     <Z start> <Z end> <Z steps> \n"
	  "  Write out a single axis-aligned block with the given dimensions\n"
	  "and coordinate extents. \n"
	); 
	if (why!=NULL)
		printf("Exiting> %s\n",why);
	exit(1);
}

makefloParam parameters;

int main(int argc,char *argv[]) 
{
//Parse the command line arguments
	if (argc!=11) printUsage("Not enough command-line arguments");
	int curArg=1;
	const char *outMesh=argv[curArg++];
	blockDim dim;
	vector3d start,end;
	int axis;
	static const char *axisNames[]={"X","Y","Z"};
	for (axis=0;axis<3;axis++) {
		double s,e;
		if (1!=sscanf(argv[curArg++],"%lg",&s))
			printUsage("Couldn't parse axis start");
		if (1!=sscanf(argv[curArg++],"%lg",&e))
			printUsage("Couldn't parse axis end");
		start[axis]=s; end[axis]=e;
		if (1!=sscanf(argv[curArg++],"%d",&dim[axis]))
			printUsage("Couldn't parse axis size");
		printf("Along %s axis: (%f - %f) in %d steps\n",axisNames[axis],
			start[axis],end[axis],dim[axis]);
	}
	
//Build a regular 3D block of points
	vector3d *locs=new vector3d[dim.getSize()];
	blockLoc i;
	for (i[2]=0; i[2]<dim[2]; i[2]++)
	for (i[1]=0; i[1]<dim[1]; i[1]++)
	for (i[0]=0; i[0]<dim[0]; i[0]++) { 
		vector3d p;
		for (axis=0;axis<3;axis++)
			p[axis]=start[axis]+((end[axis]-start[axis])*i[axis])/(dim[axis]-1);
		locs[dim[i]]=p;
	}
	printf("Locations built\n");

	vector<block *> blocks;
	blocks.push_back(new block(dim,0,0,locs));
	printf("Block built\n");
	
//Write out the new block
	writeBlocks(blocks,outMesh);
	printf("Program finished successfully\n");
	return 0;
}






