/*
Demonstrate the use of the new TCHARM_Migrate_to routine.

Orion Sky Lawlor, olawlor@acm.org, 2003/3/21
*/
#include <stdio.h>
#include "ampi.h"
#include "tcharmc.h" /* for TCHARM_Migrate */
#include "charm++.h" /* for CkMyPe()*/

/* Print the locations of each virtual processor (collective) */
void printLocations(const char *desc) {
	int myVP, nVP, myPE;
        MPI_Comm_rank(MPI_COMM_WORLD,&myVP); //My virtual processor
        MPI_Comm_size(MPI_COMM_WORLD,&nVP); //Number of VP's
        myPE=CkMyPe(); //Physical processor I'm currently on
        int *VP_to_PE=NULL;
        if (myVP==0) VP_to_PE=new int[nVP];
        MPI_Gather(&myPE,1,MPI_INT, VP_to_PE,1,MPI_INT, 0, MPI_COMM_WORLD);
        if (myVP==0)
        { /* Now VP_to_PE[v] contains VP v's physical processor */
		for (int i=0;i<nVP;i++)
			CkPrintf("%s VP[%d]=pe %d\n",desc,i,VP_to_PE[i]);
        }
}

int main(int argc,char **argv)
{
	MPI_Init(&argc,&argv);
	int rank,size;
	
	MPI_Comm_rank(MPI_COMM_WORLD, &rank);
	MPI_Comm_size(MPI_COMM_WORLD, &size);
	printLocations("before");
	if (rank==size/2) {
		int dest=CkNumPes()-1;
		CkPrintf("VP %d migrating to pe %d\n",
			rank,dest);
		TCHARM_Migrate_to(dest);
	}
	printLocations("after");
	
	MPI_Finalize();
	return 0;
}
