#include <math.h>
#include "ckcallback-ccs.h"
#include "app.decl.h"

CProxy_appArray appProxy;

void callExit(void *ccs_msg) {
	CkExit();
}

class app: public Chare {
public:
  app(CkArgMsg *m) {
    appProxy = CProxy_appArray::ckNew(1);
    CkCallback cb(CkIndex_appArray::testEcho(0),appProxy[0]);
    CcsRegisterHandler("testEcho",cb);
    CcsRegisterHandler("pleaseExit",CkCallback((Ck1CallbackFn)callExit));
  }
};

class appArray: public ArrayElement1D {
public: 
  appArray(CkMigrateMessage * m) {};
  appArray() {}

  void testEcho(CkCcsRequestMsg *m) {
    CkCallback cb(m->reply);
    /* Just send the network its own data back again */
    CmiPrintf("Server> Echoing %d bytes of data\n",m->length);
    cb.send(m->length,m->data);
  }
};

#include "app.def.h"

