/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class ColorMap {
    byte[] red = new byte[256];
    byte[] green = new byte[256];
    byte[] blue = new byte[256];
    ColorModel cm;
    boolean cm_cached = false;

    ColorMap() {
    }

    public void addBreak(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.cm_cached = false;
        n6 -= n2;
        n7 -= n3;
        n8 -= n4;
        int n9 = n;
        while (n9 <= n5) {
            float f = (float)(n9 - n) / (float)(n5 - n);
            this.red[n9] = (byte)((float)n2 + f * (float)n6);
            this.green[n9] = (byte)((float)n3 + f * (float)n7);
            this.blue[n9] = (byte)((float)n4 + f * (float)n8);
            ++n9;
        }
    }

    public void addBreaks(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = 1;
        while (n < nArray.length) {
            this.addBreak(nArray[n - 1], nArray2[n - 1], nArray3[n - 1], nArray4[n - 1], nArray[n], nArray2[n], nArray3[n], nArray4[n]);
            ++n;
        }
    }

    public int apply(byte by) {
        return 0xFF000000 | this.red[by] << 16 | this.green[by] << 8 | this.blue[by] << 0;
    }

    public ColorModel getColorModel() {
        if (!this.cm_cached) {
            this.cm = new IndexColorModel(8, 256, this.red, this.green, this.blue, -1);
            this.cm_cached = true;
        }
        return this.cm;
    }

    public void initGrey() {
        this.cm_cached = false;
        int n = 0;
        while (n < 256) {
            this.green[n] = this.blue[n] = (byte)(0xFF & n);
            this.red[n] = this.blue[n];
            ++n;
        }
    }
}

